

<?php $__env->startSection('content'); ?>
    <div class="row mb-4">
        <div class="col-12 col-md-6">
            <h2 class="fw-light"><?php echo e(__('Products & Services')); ?></h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
                    <li class="breadcrumb-item active"><?php echo e(__('Products')); ?></li>
                </ol>
            </nav>
        </div>
        <div class="col-12 col-md-6 text-md-end">
            <a href="<?php echo e(route('products.create')); ?>" class="btn btn-primary">
                <i class="fas fa-plus-circle me-2"></i><?php echo e(__('New Product')); ?>

            </a>
        </div>
    </div>

    <div class="card">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead class="table-dark">
                        <tr>
                            <th><?php echo e(__('Name')); ?></th>
                            <th><?php echo e(__('Type')); ?></th>
                            <th><?php echo e(__('SKU')); ?></th>
                            <th class="text-end"><?php echo e(__('Amount')); ?></th>
                            <th><?php echo e(__('Actions')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td class="fw-bold"><?php echo e($product->name); ?></td>
                                <td>
                                    <?php if($product->type == 'service'): ?>
                                        <span class="badge bg-info text-dark"><?php echo e(__('Service')); ?></span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary"><?php echo e(__('Product')); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($product->sku ?? '-'); ?></td>
                                <td class="text-end fw-bold"><?php echo e(number_format($product->price, 2)); ?></td>
                                <td>
                                    <a href="<?php echo e(route('products.edit', $product)); ?>" class="btn btn-sm btn-outline-warning">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <form action="<?php echo e(route('products.destroy', $product)); ?>" method="POST" class="d-inline"
                                        onsubmit="return confirm('<?php echo e(__('Delete this product?')); ?>')">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button class="btn btn-sm btn-outline-danger">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="5" class="text-center py-5">
                                    <i class="fas fa-box-open fa-3x text-muted mb-3"></i>
                                    <h3><?php echo e(__('No products found')); ?></h3>
                                    <p class="text-muted">
                                        <?php echo e(__('Create services or products to add them to invoices easily.')); ?></p>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php if($products->hasPages()): ?>
            <div class="card-footer">
                <?php echo e($products->links()); ?>

            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\code\resources\views/products/index.blade.php ENDPATH**/ ?>