

<?php $__env->startSection('content'); ?>
    <div class="row mb-4">
        <div class="col-12">
            <h2 class="fw-light"><?php echo e(__('Settings')); ?></h2>
        </div>
    </div>

    <div class="row">
        <div class="col-md-3">
            <div class="list-group list-group-flush mb-4 bg-transparent">
                <a class="list-group-item list-group-item-action bg-transparent text-white active" id="list-general-list"
                    data-bs-toggle="list" href="#list-general" role="tab"><?php echo e(__('General Settings')); ?></a>
                <a class="list-group-item list-group-item-action bg-transparent text-white" id="list-whmcs-list"
                    data-bs-toggle="list" href="#list-whmcs" role="tab"><?php echo e(__('WHMCS Integration')); ?></a>
                <a class="list-group-item list-group-item-action bg-transparent text-white" id="list-wasender-list"
                    data-bs-toggle="list" href="#list-wasender" role="tab"><?php echo e(__('WaSender Setup')); ?></a>
                <a class="list-group-item list-group-item-action bg-transparent text-white" id="list-smtp-list"
                    data-bs-toggle="list" href="#list-smtp" role="tab"><?php echo e(__('SMTP Configuration')); ?></a>
                <a class="list-group-item list-group-item-action bg-transparent text-white" id="list-templates-list"
                    data-bs-toggle="list" href="#list-templates" role="tab"><?php echo e(__('Email Templates')); ?></a>
                <a class="list-group-item list-group-item-action bg-transparent text-white" id="list-closing-list"
                    data-bs-toggle="list" href="#list-closing" role="tab"><i
                        class="fas fa-calendar-check me-2"></i><?php echo e(__('Monthly Closing')); ?></a>
                <a href="<?php echo e(route('settings.customer-groups.index')); ?>"
                    class="list-group-item list-group-item-action bg-transparent text-white">
                    <i class="fas fa-users me-2"></i><?php echo e(__('Customer Groups')); ?>

                </a>
                <a href="<?php echo e(route('settings.backup.index')); ?>"
                    class="list-group-item list-group-item-action bg-transparent text-white">
                    <i class="fas fa-database me-2"></i><?php echo e(__('Backup & Restore')); ?>

                </a>
            </div>
        </div>

        <div class="col-md-9">
            <div class="tab-content" id="nav-tabContent">
                <!-- General Settings -->
                <div class="tab-pane fade show active" id="list-general" role="tabpanel">
                    <div class="card">
                        <div class="card-header"><?php echo e(__('General Settings')); ?></div>
                        <div class="card-body">
                            <form action="<?php echo e(route('settings.general.update')); ?>" method="POST"
                                enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <div class="col-md-8">
                                        <div class="mb-3">
                                            <label class="form-label"><?php echo e(__('Company Name')); ?></label>
                                            <input type="text" name="company_name" class="form-control"
                                                value="<?php echo e($settings['general']['company_name'] ?? config('app.name')); ?>"
                                                required>
                                        </div>
                                        <div class="mb-3">
                                            <label class="form-label"><?php echo e(__('Company Address')); ?></label>
                                            <textarea name="company_address" class="form-control"
                                                rows="2"><?php echo e($settings['general']['company_address'] ?? ''); ?></textarea>
                                        </div>
                                        <div class="mb-3">
                                            <label class="form-label"><?php echo e(__('Company Tax ID')); ?></label>
                                            <input type="text" name="company_tax_id" class="form-control"
                                                value="<?php echo e($settings['general']['company_tax_id'] ?? ''); ?>">
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label"><?php echo e(__('Company Phone')); ?></label>
                                                <input type="text" name="company_phone" class="form-control"
                                                    value="<?php echo e($settings['general']['company_phone'] ?? ''); ?>">
                                            </div>
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label"><?php echo e(__('Company Email')); ?></label>
                                                <input type="email" name="company_email" class="form-control"
                                                    value="<?php echo e($settings['general']['company_email'] ?? ''); ?>">
                                            </div>
                                            <div class="col-12 mb-3">
                                                <label class="form-label"><?php echo e(__('Company Website')); ?></label>
                                                <input type="url" name="company_website" class="form-control"
                                                    value="<?php echo e($settings['general']['company_website'] ?? ''); ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4 text-center">
                                        <label class="form-label d-block"><?php echo e(__('Company Logo')); ?></label>
                                        <?php if(!empty($settings['general']['company_logo'])): ?>
                                            <img src="<?php echo e(asset('storage/' . $settings['general']['company_logo'])); ?>"
                                                class="img-thumbnail mb-2" style="max-height: 100px;">
                                        <?php else: ?>
                                            <div class="border p-3 mb-2 text-muted">No Logo</div>
                                        <?php endif; ?>
                                        <input type="file" name="company_logo" class="form-control form-control-sm">
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label"><?php echo e(__('Default Language')); ?></label>
                                        <select name="default_language" class="form-select">
                                            <option value="en" <?php echo e(($settings['general']['default_language'] ?? 'en') == 'en' ? 'selected' : ''); ?>><?php echo e(__('English')); ?></option>
                                            <option value="ar" <?php echo e(($settings['general']['default_language'] ?? 'en') == 'ar' ? 'selected' : ''); ?>><?php echo e(__('Arabic (العربية)')); ?></option>
                                        </select>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label"><?php echo e(__('Timezone')); ?></label>
                                        <input type="text" name="timezone" class="form-control"
                                            value="<?php echo e($settings['general']['timezone'] ?? 'UTC'); ?>">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label text-danger fw-bold"><i
                                                class="fas fa-lock me-1"></i><?php echo e(__('Accounting Lock Date')); ?></label>
                                        <input type="date" name="accounting_lock_date" class="form-control"
                                            value="<?php echo e($settings['general']['accounting_lock_date'] ?? ''); ?>">
                                        <small
                                            class="text-muted"><?php echo e(__('No transactions can be added or edited on or before this date.')); ?></small>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label text-success fw-bold"><i
                                                class="fas fa-chart-line me-1"></i><?php echo e(__('Expected Annual Revenue')); ?></label>
                                        <div class="input-group">
                                            <input type="number" name="expected_annual_revenue" class="form-control"
                                                value="<?php echo e($settings['general']['expected_annual_revenue'] ?? '1000000'); ?>">
                                            <span class="input-group-text">EGP</span>
                                        </div>
                                        <small
                                            class="text-muted"><?php echo e(__('Used for calculating share price (Base price = Revenue / 10,000).')); ?></small>
                                    </div>
                                    <div class="col-12 mb-3">
                                        <div class="form-check form-switch p-3 bg-dark border border-secondary rounded">
                                            <input class="form-check-input ms-0 me-3" type="checkbox" name="enable_otp"
                                                value="1" id="enable_otp" <?php echo e(($settings['security']['enable_otp'] ?? false) ? 'checked' : ''); ?>>
                                            <label class="form-check-label fw-bold text-info" for="enable_otp">
                                                <i class="fab fa-whatsapp me-2"></i><?php echo e(__('Enable WhatsApp OTP Login')); ?>

                                            </label>
                                            <small class="d-block text-muted mt-1 ms-5">
                                                <?php echo e(__('When enabled, users will receive a verification code on WhatsApp after entering their credentials.')); ?>

                                                <?php echo e(__('Requires WaSender configuration.')); ?>

                                            </small>
                                        </div>
                                    </div>
                                </div>

                                <button type="submit" class="btn btn-primary"><?php echo e(__('Save General Settings')); ?></button>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- WHMCS Settings -->
                <div class="tab-pane fade" id="list-whmcs" role="tabpanel">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <span><?php echo e(__('WHMCS Configuration')); ?></span>
                            <button type="button" class="btn btn-sm btn-outline-info"
                                id="test-whmcs"><?php echo e(__('Test Connection')); ?></button>
                        </div>
                        <div class="card-body">
                            <form action="<?php echo e(route('settings.whmcs.update')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <div class="mb-3">
                                    <label class="form-label">WHMCS API URL</label>
                                    <input type="url" name="api_url" class="form-control"
                                        placeholder="https://yourdomian.com/includes/api.php"
                                        value="<?php echo e($settings['whmcs']['api_url'] ?? ''); ?>">
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">API Identifier</label>
                                    <input type="text" name="api_identifier" class="form-control"
                                        value="<?php echo e($settings['whmcs']['api_identifier'] ?? ''); ?>">
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">API Secret</label>
                                    <input type="password" name="api_secret" class="form-control"
                                        value="<?php echo e($settings['whmcs']['api_secret'] ?? ''); ?>">
                                </div>
                                <div class="mb-3 form-check form-switch">
                                    <input class="form-check-input" type="checkbox" name="auto_sync" value="1"
                                        id="whmcs_auto_sync" <?php echo e(($settings['whmcs']['auto_sync'] ?? false) ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="whmcs_auto_sync">Auto Sync Clients Daily</label>
                                </div>
                                <button type="submit" class="btn btn-primary"><?php echo e(__('Save WHMCS Settings')); ?></button>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- WaSender Settings -->
                <div class="tab-pane fade" id="list-wasender" role="tabpanel">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <span><?php echo e(__('WaSender (WhatsApp) Configuration')); ?></span>
                            <button type="button" class="btn btn-sm btn-outline-info"
                                id="test-wasender"><?php echo e(__('Check Session')); ?></button>
                        </div>
                        <div class="card-body">
                            <form action="<?php echo e(route('settings.wasender.update')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <div class="mb-3">
                                    <label class="form-label">API URL</label>
                                    <input type="url" name="api_url" class="form-control"
                                        value="<?php echo e($settings['wasender']['api_url'] ?? 'https://api.wasenderapi.com'); ?>">
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">API Key</label>
                                    <input type="text" name="api_key" class="form-control"
                                        value="<?php echo e($settings['wasender']['api_key'] ?? ''); ?>">
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Session ID</label>
                                    <input type="text" name="session_id" class="form-control"
                                        value="<?php echo e($settings['wasender']['session_id'] ?? ''); ?>">
                                </div>
                                <div class="alert alert-info small" id="wasender-status">
                                    <i class="fas fa-info-circle me-2"></i> Save credentials to unlock features.
                                </div>
                                <button type="submit" class="btn btn-primary"><?php echo e(__('Save WaSender Settings')); ?></button>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- SMTP Settings -->
                <div class="tab-pane fade" id="list-smtp" role="tabpanel">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <span><?php echo e(__('SMTP Email Configuration')); ?></span>
                            <button type="button" class="btn btn-sm btn-outline-info"
                                id="test-smtp"><?php echo e(__('Test Email')); ?></button>
                        </div>
                        <div class="card-body">
                            <form action="<?php echo e(route('settings.smtp.update')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <div class="row mb-3">
                                    <div class="col-md-8">
                                        <label class="form-label">Host</label>
                                        <input type="text" name="host" class="form-control"
                                            value="<?php echo e($settings['smtp']['host'] ?? ''); ?>">
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label">Port</label>
                                        <input type="number" name="port" class="form-control"
                                            value="<?php echo e($settings['smtp']['port'] ?? '587'); ?>">
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Username</label>
                                    <input type="text" name="username" class="form-control"
                                        value="<?php echo e($settings['smtp']['username'] ?? ''); ?>">
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Password</label>
                                    <input type="password" name="password" class="form-control"
                                        value="<?php echo e($settings['smtp']['password'] ?? ''); ?>">
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Encryption</label>
                                    <select name="encryption" class="form-select">
                                        <option value="tls" <?php echo e(($settings['smtp']['encryption'] ?? 'tls') == 'tls' ? 'selected' : ''); ?>>TLS</option>
                                        <option value="ssl" <?php echo e(($settings['smtp']['encryption'] ?? '') == 'ssl' ? 'selected' : ''); ?>>SSL</option>
                                        <option value="null" <?php echo e(($settings['smtp']['encryption'] ?? '') == 'null' ? 'selected' : ''); ?>>None</option>
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">From Address</label>
                                    <input type="email" name="from_address" class="form-control"
                                        value="<?php echo e($settings['smtp']['from_address'] ?? ''); ?>">
                                </div>
                                <button type="submit" class="btn btn-primary"><?php echo e(__('Save SMTP Settings')); ?></button>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- Email Templates -->
                <div class="tab-pane fade" id="list-templates" role="tabpanel">
                    <div class="card mb-3">
                        <div class="card-header"><?php echo e(__('Create New Template')); ?></div>
                        <div class="card-body">
                            <form action="<?php echo e(route('settings.templates.store')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <div class="mb-2">
                                    <input type="text" name="name" class="form-control"
                                        placeholder="Template Name (unique slug)" required>
                                </div>
                                <div class="mb-2">
                                    <input type="text" name="subject" class="form-control" placeholder="Email Subject"
                                        required>
                                </div>
                                <div class="mb-2">
                                    <textarea name="body" class="form-control" rows="3"
                                        placeholder="Template Body (use {{variable}} for placeholders)"
                                        required></textarea>
                                </div>
                                <button type="submit" class="btn btn-sm btn-success"><?php echo e(__('Create Template')); ?></button>
                            </form>
                        </div>
                    </div>

                    <div class="list-group">
                        <?php $__currentLoopData = $emailTemplates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $template): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="list-group-item bg-dark border-secondary text-white">
                                <div class="d-flex w-100 justify-content-between">
                                    <h5 class="mb-1"><?php echo e($template->name); ?></h5>
                                    <form action="<?php echo e(route('settings.templates.destroy', $template)); ?>" method="POST"
                                        onsubmit="return confirm('Delete template?');">
                                        <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-sm btn-danger"><i
                                                class="fas fa-trash"></i></button>
                                    </form>
                                </div>
                                <p class="mb-1">Subject: <?php echo e($template->subject); ?></p>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
                <!-- Monthly Closing -->
                <div class="tab-pane fade" id="list-closing" role="tabpanel">
                    <div class="card bg-dark border-secondary">
                        <div class="card-header border-secondary bg-secondary text-white fw-bold">
                            <i class="fas fa-lock me-2"></i> <?php echo e(__('Accounting Monthly Closing')); ?>

                        </div>
                        <div class="card-body">
                            <div class="alert alert-warning mb-4 bg-transparent border-warning text-warning">
                                <i class="fas fa-exclamation-triangle me-2"></i>
                                <strong>Important:</strong> Closing a month will prevent any modifications (Create, Update,
                                Delete) for all financial transactions, invoices, and journal entries on or before the
                                selected date.
                            </div>

                            <form action="<?php echo e(route('settings.close-month')); ?>" method="POST" class="row align-items-end">
                                <?php echo csrf_field(); ?>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Lock All Transactions Up To:</label>
                                    <input type="date" name="lock_date" class="form-control"
                                        value="<?php echo e($settings['general']['accounting_lock_date'] ?? ''); ?>" required>
                                    <small class="text-muted d-block mt-1">Currently locked up to:
                                        <strong><?php echo e($settings['general']['accounting_lock_date'] ?? 'None'); ?></strong></small>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <button type="submit" class="btn btn-danger w-100"
                                        onclick="return confirm('<?php echo e(__('Are you sure? This will lock all accounting operations for the selected period.')); ?>')">
                                        <i class="fas fa-calendar-check me-2"></i> <?php echo e(__('Confirm Monthly Closing')); ?>

                                        <div class="small fw-light"><?php echo e(__('This cannot be easily undone')); ?></div>
                                    </button>
                                </div>
                            </form>

                            <hr class="border-secondary my-4">

                            <h5><?php echo e(__('Closing History')); ?></h5>
                            <p class="text-muted small">The system will record the date and the user who performed the
                                closing for audit purposes.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
        <script>
            // Test WHMCS
            $('#test-whmcs').click(function () {
                const btn = $(this);
                btn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> Testing...');

                $.post("<?php echo e(route('settings.whmcs.test')); ?>", {
                    _token: "<?php echo e(csrf_token()); ?>"
                })
                    .done(function (data) {
                        alert(data.message);
                    })
                    .fail(function () {
                        alert('Connection failed. Please check credentials.');
                    })
                    .always(function () {
                        btn.prop('disabled', false).text('Test Connection');
                    });
            });

            // Test WaSender
            $('#test-wasender').click(function () {
                const btn = $(this);
                btn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> Checking...');

                $.post("<?php echo e(route('settings.wasender.test')); ?>", {
                    _token: "<?php echo e(csrf_token()); ?>"
                })
                    .done(function (data) {
                        alert(data.message + ' (Status: ' + data.status + ')');
                    })
                    .fail(function () {
                        alert('Connection failed.');
                    })
                    .always(function () {
                        btn.prop('disabled', false).text('Check Session');
                    });
            });

            // Test SMTP
            $('#test-smtp').click(function () {
                const btn = $(this);
                btn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> Sending...');

                $.post("<?php echo e(route('settings.smtp.test')); ?>", {
                    _token: "<?php echo e(csrf_token()); ?>"
                })
                    .done(function (data) {
                        alert(data.message);
                    })
                    .fail(function () {
                        alert('Failed to send test email.');
                    })
                    .always(function () {
                        btn.prop('disabled', false).text('Test Email');
                    });
            });
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\code\resources\views/settings/index.blade.php ENDPATH**/ ?>