

<?php $__env->startSection('content'); ?>
    <div class="row mb-4">
        <div class="col-12 col-md-6">
            <h2 class="fw-light">سجل المعاملات المالية</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">لوحة التحكم</a></li>
                    <li class="breadcrumb-item active">المعاملات المالية</li>
                </ol>
            </nav>
        </div>
    </div>

    <div class="card mb-4">
        <div class="card-body">
            <form action="<?php echo e(route('accounting.transactions.index')); ?>" method="GET" class="row g-3">
                <div class="col-md-3">
                    <label class="form-label">من تاريخ</label>
                    <input type="date" name="date_from" class="form-control" value="<?php echo e(request('date_from')); ?>">
                </div>
                <div class="col-md-3">
                    <label class="form-label">إلى تاريخ</label>
                    <input type="date" name="date_to" class="form-control" value="<?php echo e(request('date_to')); ?>">
                </div>
                <div class="col-md-3">
                    <label class="form-label">الخزنة</label>
                    <select name="treasury_id" class="form-select">
                        <option value="">الكل</option>
                        <?php $__currentLoopData = $treasuries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $treasury): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($treasury->id); ?>" <?php echo e(request('treasury_id') == $treasury->id ? 'selected' : ''); ?>>
                                <?php echo e($treasury->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-3 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary w-100">بحث</button>
                </div>
            </form>
        </div>
    </div>

    <ul class="nav nav-tabs mb-3" id="transTabs" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link active" id="treasury-tab" data-bs-toggle="tab" data-bs-target="#treasury" type="button"
                role="tab" aria-selected="true">
                <i class="fas fa-university me-2"></i>حركات الخزنة
            </button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="wallet-tab" data-bs-toggle="tab" data-bs-target="#wallet" type="button" role="tab"
                aria-selected="false">
                <i class="fas fa-wallet me-2"></i>محافظ العملاء
            </button>
        </li>
    </ul>

    <div class="tab-content" id="transTabsContent">
        <!-- Treasury Tab -->
        <div class="tab-pane fade show active" id="treasury" role="tabpanel">
            <div class="card">
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="table-dark">
                            <tr>
                                <th>#</th>
                                <th>التاريخ</th>
                                <th>النوع</th>
                                <th>المبلغ</th>
                                <th>الخزنة</th>
                                <th>الوصف</th>
                                <th>المستخدم</th>
                                <th>المرجع</th>
                                <th>الاجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $treasuryTransactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($transaction->id); ?></td>
                                    <td><?php echo e($transaction->date->format('Y-m-d')); ?></td>
                                    <td>
                                        <span
                                            class="badge bg-<?php echo e($transaction->type == 'in' ? 'success' : ($transaction->type == 'out' ? 'danger' : 'info')); ?>">
                                            <?php echo e($transaction->type == 'in' ? 'إيراد' : ($transaction->type == 'out' ? 'مصروف' : 'أخرى')); ?>

                                        </span>
                                    </td>
                                    <td class="fw-bold <?php echo e($transaction->type == 'income' ? 'text-success' : 'text-danger'); ?>">
                                        <?php echo e(number_format($transaction->amount, 2)); ?>

                                    </td>
                                    <td><?php echo e($transaction->treasury->name ?? '-'); ?></td>
                                    <td><?php echo e($transaction->description); ?></td>
                                    <td><?php echo e($transaction->user->name ?? '-'); ?></td>
                                    <td>
                                        <?php if($transaction->model_type == 'App\Models\Invoice'): ?>
                                            <a href="<?php echo e(route('accounting.invoices.show', $transaction->model_id)); ?>">فاتورة
                                                #<?php echo e($transaction->model_id); ?></a>
                                        <?php else: ?>
                                            -
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <form action="<?php echo e(route('accounting.transactions.destroy', $transaction->id)); ?>"
                                            method="POST"
                                            onsubmit="return confirm('هل أنت متأكد من الحذف؟ سيتم استرجاع رصيد الخزنة.')">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-sm btn-danger">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="8" class="text-center py-4 text-muted">لا توجد حركات</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <div class="card-footer">
                    <?php echo e($treasuryTransactions->links()); ?>

                </div>
            </div>
        </div>

        <!-- Wallet Tab -->
        <div class="tab-pane fade" id="wallet" role="tabpanel">
            <div class="card">
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="table-dark">
                            <tr>
                                <th>#</th>
                                <th>التاريخ</th>
                                <th>العميل</th>
                                <th>النوع</th>
                                <th>المبلغ</th>
                                <th>الوصف</th>
                                <th>المستخدم</th>
                                <th>الاجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $walletTransactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($transaction->id); ?></td>
                                    <td><?php echo e($transaction->created_at->format('Y-m-d H:i')); ?></td>
                                    <td>
                                        <?php if($transaction->customer): ?>
                                            <a
                                                href="<?php echo e(route('customers.show', $transaction->customer_id)); ?>"><?php echo e($transaction->customer->name); ?></a>
                                        <?php else: ?>
                                            <span class="text-muted">عميل محذوف</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if(in_array($transaction->type, ['deposit', 'adjustment']) && $transaction->amount > 0): ?>
                                            <span class="badge bg-success">إيداع</span>
                                        <?php else: ?>
                                            <span class="badge bg-danger">خصم</span>
                                        <?php endif; ?>
                                        <small class="text-muted">
                                            (<?php echo e($transaction->type == 'deposit' ? 'إيداع' : ($transaction->type == 'adjustment' ? 'تسويه' : 'خصم')); ?>)
                                        </small>
                                    </td>
                                    <td
                                        class="fw-bold <?php echo e((in_array($transaction->type, ['deposit', 'adjustment']) && $transaction->amount > 0) ? 'text-success' : 'text-danger'); ?>">
                                        <?php echo e(number_format($transaction->amount, 2)); ?>

                                    </td>
                                    <td><?php echo e($transaction->notes); ?></td>
                                    <td><?php echo e($transaction->user->name ?? '-'); ?></td>
                                    <td>
                                        <form
                                            action="<?php echo e(action([\App\Http\Controllers\CustomerController::class, 'destroyWalletTransaction'], ['customer' => $transaction->customer_id, 'transaction' => $transaction->id])); ?>"
                                            method="POST" onsubmit="return confirm('هل أنت متأكد من الحذف؟')">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-sm btn-danger">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="7" class="text-center py-4 text-muted">لا توجد حركات</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <div class="card-footer">
                    <?php echo e($walletTransactions->links()); ?>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\code\resources\views/accounting/transactions/index.blade.php ENDPATH**/ ?>