

<?php $__env->startSection('content'); ?>
    <div class="row mb-4">
        <div class="col-12 d-flex justify-content-between align-items-center flex-wrap gap-3">
            <div>
                <h2 class="fw-light"><?php echo e(__('Units & Measures')); ?></h2>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
                        <li class="breadcrumb-item active"><?php echo e(__('Units')); ?></li>
                    </ol>
                </nav>
            </div>
            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createUnitModal">
                <i class="fas fa-plus me-1"></i><?php echo e(__('Add Unit')); ?>

            </button>
        </div>
    </div>

    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>
    <?php if(session('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?php echo e(session('error')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <div class="row g-4">
        <!-- Quantity Units -->
        <div class="col-lg-6">
            <div class="card bg-dark border-secondary h-100">
                <div class="card-header border-secondary">
                    <h5 class="mb-0"><i class="fas fa-boxes me-2"></i><?php echo e(__('Quantity Units')); ?></h5>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-dark table-hover mb-0 align-middle">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('Name')); ?></th>
                                    <th><?php echo e(__('Short')); ?></th>
                                    <th><?php echo e(__('Base Unit')); ?></th>
                                    <th><?php echo e(__('Factor')); ?></th>
                                    <th class="text-end"><?php echo e(__('Actions')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $units->where('type', 'quantity'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td class="fw-bold"><?php echo e($unit->name); ?></td>
                                        <td><span class="badge bg-secondary"><?php echo e($unit->short_name ?? '-'); ?></span></td>
                                        <td><?php echo e($unit->parent ? $unit->parent->name : '-'); ?></td>
                                        <td><?php echo e($unit->conversion_factor ?? '-'); ?></td>
                                        <td class="text-end">
                                            <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal"
                                                data-bs-target="#editUnitModal<?php echo e($unit->id); ?>">
                                                <i class="fas fa-edit"></i>
                                            </button>
                                            <form action="<?php echo e(route('units.destroy', $unit)); ?>" method="POST" class="d-inline"
                                                onsubmit="return confirm('<?php echo e(__('Are you sure?')); ?>')">
                                                <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn btn-sm btn-outline-danger">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>

                                    <!-- Edit Modal -->
                                    <div class="modal fade" id="editUnitModal<?php echo e($unit->id); ?>" tabindex="-1">
                                        <div class="modal-dialog">
                                            <div class="modal-content bg-dark text-white">
                                                <form action="<?php echo e(route('units.update', $unit)); ?>" method="POST">
                                                    <?php echo csrf_field(); ?> <?php echo method_field('PUT'); ?>
                                                    <div class="modal-header border-secondary">
                                                        <h5 class="modal-title"><?php echo e(__('Edit Unit')); ?></h5>
                                                        <button type="button" class="btn-close btn-close-white"
                                                            data-bs-dismiss="modal"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <div class="mb-3">
                                                            <label class="form-label"><?php echo e(__('Name')); ?> <span
                                                                    class="text-danger">*</span></label>
                                                            <input type="text" name="name"
                                                                class="form-control bg-dark text-white border-secondary"
                                                                value="<?php echo e($unit->name); ?>" required>
                                                        </div>
                                                        <div class="mb-3">
                                                            <label class="form-label"><?php echo e(__('Short Name')); ?></label>
                                                            <input type="text" name="short_name"
                                                                class="form-control bg-dark text-white border-secondary"
                                                                value="<?php echo e($unit->short_name); ?>">
                                                        </div>
                                                        <div class="mb-3">
                                                            <label class="form-label"><?php echo e(__('Type')); ?></label>
                                                            <select name="type"
                                                                class="form-select bg-dark text-white border-secondary"
                                                                required>
                                                                <option value="quantity" <?php echo e($unit->type == 'quantity' ? 'selected' : ''); ?>><?php echo e(__('Quantity')); ?></option>
                                                                <option value="time" <?php echo e($unit->type == 'time' ? 'selected' : ''); ?>><?php echo e(__('Time')); ?></option>
                                                            </select>
                                                        </div>
                                                        <div class="mb-3">
                                                            <label class="form-label"><?php echo e(__('Base Unit')); ?></label>
                                                            <select name="parent_id"
                                                                class="form-select bg-dark text-white border-secondary">
                                                                <option value=""><?php echo e(__('None (Base Unit)')); ?></option>
                                                                <?php $__currentLoopData = $units->where('id', '!=', $unit->id); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <option value="<?php echo e($parent->id); ?>" <?php echo e($unit->parent_id == $parent->id ? 'selected' : ''); ?>>
                                                                        <?php echo e($parent->name); ?>

                                                                    </option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>
                                                        </div>
                                                        <div class="mb-3">
                                                            <label class="form-label"><?php echo e(__('Conversion Factor')); ?></label>
                                                            <input type="number" step="0.0001" name="conversion_factor"
                                                                class="form-control bg-dark text-white border-secondary"
                                                                value="<?php echo e($unit->conversion_factor); ?>">
                                                            <small
                                                                class="text-muted"><?php echo e(__('e.g., 1 Box = 12 Pieces → Factor = 12')); ?></small>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer border-secondary">
                                                        <button type="button" class="btn btn-secondary"
                                                            data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                                                        <button type="submit"
                                                            class="btn btn-primary"><?php echo e(__('Update')); ?></button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="5" class="text-center py-4 text-muted">
                                            <?php echo e(__('No quantity units defined.')); ?>

                                        </td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Time Units -->
        <div class="col-lg-6">
            <div class="card bg-dark border-secondary h-100">
                <div class="card-header border-secondary">
                    <h5 class="mb-0"><i class="fas fa-clock me-2"></i><?php echo e(__('Time Units')); ?></h5>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-dark table-hover mb-0 align-middle">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('Name')); ?></th>
                                    <th><?php echo e(__('Short')); ?></th>
                                    <th><?php echo e(__('Base Unit')); ?></th>
                                    <th><?php echo e(__('Factor')); ?></th>
                                    <th class="text-end"><?php echo e(__('Actions')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $units->where('type', 'time'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td class="fw-bold"><?php echo e($unit->name); ?></td>
                                        <td><span class="badge bg-info"><?php echo e($unit->short_name ?? '-'); ?></span></td>
                                        <td><?php echo e($unit->parent ? $unit->parent->name : '-'); ?></td>
                                        <td><?php echo e($unit->conversion_factor ?? '-'); ?></td>
                                        <td class="text-end">
                                            <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal"
                                                data-bs-target="#editUnitModal<?php echo e($unit->id); ?>">
                                                <i class="fas fa-edit"></i>
                                            </button>
                                            <form action="<?php echo e(route('units.destroy', $unit)); ?>" method="POST" class="d-inline"
                                                onsubmit="return confirm('<?php echo e(__('Are you sure?')); ?>')">
                                                <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn btn-sm btn-outline-danger">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="5" class="text-center py-4 text-muted">
                                            <?php echo e(__('No time units defined.')); ?>

                                        </td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Create Unit Modal -->
    <div class="modal fade" id="createUnitModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content bg-dark text-white">
                <form action="<?php echo e(route('units.store')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-header border-secondary">
                        <h5 class="modal-title"><i class="fas fa-plus me-2"></i><?php echo e(__('Add New Unit')); ?></h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label"><?php echo e(__('Name')); ?> <span class="text-danger">*</span></label>
                            <input type="text" name="name" class="form-control bg-dark text-white border-secondary" required
                                placeholder="<?php echo e(__('e.g., Piece, Kilogram, Hour')); ?>">
                        </div>
                        <div class="mb-3">
                            <label class="form-label"><?php echo e(__('Short Name')); ?></label>
                            <input type="text" name="short_name" class="form-control bg-dark text-white border-secondary"
                                placeholder="<?php echo e(__('e.g., pcs, kg, hr')); ?>">
                        </div>
                        <div class="mb-3">
                            <label class="form-label"><?php echo e(__('Type')); ?> <span class="text-danger">*</span></label>
                            <select name="type" class="form-select bg-dark text-white border-secondary" required>
                                <option value="quantity"><?php echo e(__('Quantity')); ?></option>
                                <option value="time"><?php echo e(__('Time')); ?></option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label"><?php echo e(__('Base Unit')); ?></label>
                            <select name="parent_id" class="form-select bg-dark text-white border-secondary">
                                <option value=""><?php echo e(__('None (Base Unit)')); ?></option>
                                <?php $__currentLoopData = $units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($parent->id); ?>"><?php echo e($parent->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label"><?php echo e(__('Conversion Factor')); ?></label>
                            <input type="number" step="0.0001" name="conversion_factor"
                                class="form-control bg-dark text-white border-secondary" placeholder="1">
                            <small class="text-muted"><?php echo e(__('How many base units equal 1 of this unit')); ?></small>
                        </div>
                    </div>
                    <div class="modal-footer border-secondary">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo e(__('Create Unit')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\code\resources\views/accounting/units/index.blade.php ENDPATH**/ ?>