

<?php $__env->startSection('content'); ?>
    <div class="row mb-4">
        <div class="col-12 col-md-6">
            <h2 class="fw-light"><?php echo e(__('Investors & Shares')); ?></h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('Shares Dashboard')); ?></li>
                </ol>
            </nav>
        </div>
        <div class="col-12 col-md-6 text-md-end">
            <a href="<?php echo e(route('accounting.shares.investors.create')); ?>" class="btn btn-outline-info">
                <i class="fas fa-user-plus me-2"></i><?php echo e(__('New Investor')); ?>

            </a>
            <button type="button" class="btn btn-primary ms-2" data-bs-toggle="modal" data-bs-target="#buySharesModal">
                <i class="fas fa-shopping-cart me-2"></i><?php echo e(__('Buy Shares')); ?>

            </button>
        </div>
    </div>

    <!-- Stats Row -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card bg-dark border-secondary">
                <div class="card-body text-center py-4">
                    <div class="text-secondary small fw-bold mb-1"><?php echo e(__('CURRENT SHARE PRICE')); ?></div>
                    <h2 class="text-success mb-0"><?php echo e(number_format($currentSharePrice, 2)); ?> EGP</h2>
                    <div class="small text-muted mt-2"><?php echo e(__('Based on annual performance')); ?></div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-dark border-secondary text-white">
                <div class="card-body text-center py-4">
                    <div class="text-secondary small fw-bold mb-1"><?php echo e(__('TOTAL SHARES')); ?></div>
                    <h2 class="mb-0"><?php echo e(number_format($totalCompanyShares)); ?></h2>
                    <div class="small text-muted mt-2"><?php echo e(__('Company capitalization')); ?></div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-dark border-secondary text-white">
                <div class="card-body text-center py-4">
                    <div class="text-secondary small fw-bold mb-1"><?php echo e(__('SOLD SHARES')); ?></div>
                    <h2 class="text-primary mb-0"><?php echo e(number_format($soldShares)); ?></h2>
                    <div class="small text-muted mt-2"><?php echo e(number_format(($soldShares / $totalCompanyShares) * 100, 1)); ?>%
                        <?php echo e(__('of total')); ?>

                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-dark border-secondary text-white">
                <div class="card-body text-center py-4">
                    <div class="text-secondary small fw-bold mb-1"><?php echo e(__('AVAILABLE SHARES')); ?></div>
                    <h2 class="text-info mb-0"><?php echo e(number_format($availableShares)); ?></h2>
                    <div class="small text-muted mt-2"><?php echo e(__('Ready for purchase')); ?></div>
                </div>
            </div>
        </div>
    </div>

    <div class="card">
        <div
            class="card-header bg-transparent border-secondary text-white d-flex justify-content-between align-items-center">
            <h5 class="mb-0"><?php echo e(__('Investor List')); ?></h5>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0 align-middle">
                    <thead class="table-dark">
                        <tr>
                            <th><?php echo e(__('Investor')); ?></th>
                            <th><?php echo e(__('Shares Owned')); ?></th>
                            <th><?php echo e(__('Investment')); ?></th>
                            <th><?php echo e(__('Avg. Cost')); ?></th>
                            <th><?php echo e(__('Current Value')); ?></th>
                            <th><?php echo e(__('P/L')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $investors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $investor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <?php
                                $currentValue = $investor->total_shares * $currentSharePrice;
                                $profit = $currentValue - $investor->total_investment;
                                $profitPercent = $investor->total_investment > 0 ? ($profit / $investor->total_investment) * 100 : 0;
                            ?>
                            <tr>
                                <td>
                                    <div class="fw-bold"><?php echo e($investor->name); ?></div>
                                    <div class="small text-muted"><?php echo e($investor->phone ?? $investor->email); ?></div>
                                </td>
                                <td><?php echo e(number_format($investor->total_shares)); ?> <?php echo e(__('Units')); ?></td>
                                <td><?php echo e(number_format($investor->total_investment, 2)); ?> EGP</td>
                                <td><?php echo e(number_format($investor->avg_purchase_price, 2)); ?> EGP</td>
                                <td class="fw-bold"><?php echo e(number_format($currentValue, 2)); ?> EGP</td>
                                <td>
                                    <span class="text-<?php echo e($profit >= 0 ? 'success' : 'danger'); ?>">
                                        <?php echo e($profit >= 0 ? '+' : ''); ?><?php echo e(number_format($profit, 2)); ?>

                                        (<?php echo e(number_format($profitPercent, 1)); ?>%)
                                    </span>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="6" class="text-center py-5 text-muted"><?php echo e(__('No investors found.')); ?></td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Buy Shares Modal -->
    <div class="modal fade" id="buySharesModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content bg-dark border-secondary text-white">
                <form action="<?php echo e(route('accounting.shares.buy')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-header border-secondary">
                        <h5 class="modal-title"><?php echo e(__('Record Share Purchase')); ?></h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label"><?php echo e(__('Investor')); ?></label>
                            <select name="investor_id" class="form-select bg-dark text-white border-secondary" required>
                                <option value=""><?php echo e(__('Select Investor...')); ?></option>
                                <?php $__currentLoopData = $investors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $investor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($investor->id); ?>"><?php echo e($investor->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label"><?php echo e(__('Quantity')); ?></label>
                                <input type="number" name="shares" class="form-control" min="1" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label"><?php echo e(__('Price per Share')); ?></label>
                                <input type="number" name="price_per_share" class="form-control" step="0.01"
                                    value="<?php echo e($currentSharePrice); ?>" required>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label"><?php echo e(__('Date')); ?></label>
                            <input type="date" name="date" class="form-control" value="<?php echo e(date('Y-m-d')); ?>" required>
                        </div>
                    </div>
                    <div class="modal-footer border-secondary">
                        <button type="button" class="btn btn-outline-light"
                            data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo e(__('Confirm Purchase')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\code\resources\views/accounting/shares/index.blade.php ENDPATH**/ ?>