

<?php $__env->startSection('content'); ?>
    <div class="page-header d-flex justify-content-between align-items-center flex-wrap gap-3 mb-4">
        <div>
            <h1 class="page-title"><?php echo e(__('Profit & Loss Report')); ?></h1>
            <p class="page-subtitle"><?php echo e(__('Income vs Expenses Analysis')); ?></p>
        </div>
        <form action="<?php echo e(route('accounting.reports.profit_loss')); ?>" method="GET" class="d-flex gap-2">
            <input type="date" name="start_date" class="form-control" value="<?php echo e($startDate); ?>" required>
            <input type="date" name="end_date" class="form-control" value="<?php echo e($endDate); ?>" required>
            <button type="submit" class="btn btn-primary"><i class="fas fa-filter me-2"></i><?php echo e(__('Filter')); ?></button>
            <a href="<?php echo e(route('accounting.reports.index')); ?>" class="btn btn-outline-light"><?php echo e(__('Back')); ?></a>
        </form>
    </div>

    <!-- Summary Cards -->
    <div class="row g-4 mb-4">
        <div class="col-md-3">
            <div class="stat-card green h-100">
                <div class="stat-icon"><i class="fas fa-hand-holding-usd"></i></div>
                <div class="stat-value"><?php echo e(number_format($revenue, 2)); ?></div>
                <div class="stat-label"><?php echo e(__('Total Revenue')); ?></div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card orange h-100">
                <div class="stat-icon"><i class="fas fa-shopping-cart"></i></div>
                <div class="stat-value"><?php echo e(number_format($purchases, 2)); ?></div>
                <div class="stat-label"><?php echo e(__('Cost of Sales / Purchases')); ?></div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card pink h-100">
                <div class="stat-icon"><i class="fas fa-file-invoice-dollar"></i></div>
                <div class="stat-value"><?php echo e(number_format($totalOperatingExpenses, 2)); ?></div>
                <div class="stat-label"><?php echo e(__('Operating Expenses')); ?></div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card <?php echo e($netProfit >= 0 ? 'cyan' : 'red'); ?> h-100">
                <div class="stat-icon"><i class="fas fa-chart-line"></i></div>
                <div class="stat-value"><?php echo e(number_format($netProfit, 2)); ?></div>
                <div class="stat-label"><?php echo e(__('Net Profit')); ?></div>
                <div class="stat-trend <?php echo e($netProfit >= 0 ? 'up' : 'down'); ?>">
                    <?php echo e($netProfit >= 0 ? __('Profitable') : __('Loss')); ?>

                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <!-- Detailed Table -->
            <div class="card glass-card mb-4">
                <div class="card-header border-bottom border-light">
                    <h5 class="mb-0"><?php echo e(__('Profit & Loss Breakdown')); ?></h5>
                </div>
                <div class="card-body p-0">
                    <table class="table table-borderless mb-0">
                        <thead class="bg-black text-muted small uppercase">
                            <tr>
                                <th><?php echo e(__('Description')); ?></th>
                                <th class="text-end"><?php echo e(__('Amount')); ?> (EGP)</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr class="border-bottom border-light">
                                <td class="fw-bold text-success"><i
                                        class="fas fa-plus-circle me-2"></i><?php echo e(__('Total Revenue')); ?> (Invoices)</td>
                                <td class="text-end fw-bold text-success"><?php echo e(number_format($revenue, 2)); ?></td>
                            </tr>
                            <tr class="border-bottom border-light">
                                <td class="fw-bold text-warning"><i
                                        class="fas fa-minus-circle me-2"></i><?php echo e(__('Cost of Sales / Purchases')); ?> (Bills)
                                </td>
                                <td class="text-end fw-bold text-warning"><?php echo e(number_format($purchases, 2)); ?></td>
                            </tr>
                            <tr class="bg-black">
                                <td class="fw-bold"><?php echo e(__('GROSS PROFIT')); ?></td>
                                <td class="text-end fw-bold"><?php echo e(number_format($grossProfit, 2)); ?></td>
                            </tr>

                            <tr>
                                <td colspan="2" class="py-3 text-muted small uppercase fw-bold">
                                    <?php echo e(__('Operating Expenses')); ?></td>
                            </tr>

                            <?php $__currentLoopData = $expenseCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="border-bottom border-light opacity-75">
                                    <td class="ps-4 text-info"><?php echo e($category->name); ?></td>
                                    <td class="text-end text-info"><?php echo e(number_format($category->total_amount, 2)); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <tr class="bg-black">
                                <td class="fw-bold"><?php echo e(__('NET PROFIT')); ?></td>
                                <td class="text-end fw-bold fs-5 <?php echo e($netProfit >= 0 ? 'text-cyan' : 'text-danger'); ?>">
                                    <?php echo e(number_format($netProfit, 2)); ?>

                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <!-- Chart Section -->
            <div class="card glass-card">
                <div class="card-header border-bottom border-light py-3">
                    <h5 class="mb-0"><?php echo e(__('Income vs Expenses Chart')); ?></h5>
                </div>
                <div class="card-body">
                    <canvas id="plChart" height="250"></canvas>
                </div>
            </div>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                var ctx = document.getElementById('plChart').getContext('2d');
                var plChart = new Chart(ctx, {
                    type: 'doughnut',
                    data: {
                        labels: ['<?php echo e(__('Total Revenue')); ?>', '<?php echo e(__('Cost of Sales')); ?>', '<?php echo e(__('Operating Expenses')); ?>'],
                        datasets: [{
                            data: [<?php echo e($revenue); ?>, <?php echo e($purchases); ?>, <?php echo e($totalOperatingExpenses); ?>],
                            backgroundColor: [
                                'rgba(16, 185, 129, 0.7)', // Green
                                'rgba(249, 115, 22, 0.7)',  // Orange
                                'rgba(236, 72, 153, 0.7)',  // Pink
                            ],
                            borderColor: [
                                'rgba(16, 185, 129, 1)',
                                'rgba(249, 115, 22, 1)',
                                'rgba(236, 72, 153, 1)',
                            ],
                            borderWidth: 2,
                            hoverOffset: 15
                        }]
                    },
                    options: {
                        responsive: true,
                        cutout: '70%',
                        plugins: {
                            legend: {
                                position: 'bottom',
                                labels: { color: '#94a3b8', padding: 20 }
                            },
                        }
                    }
                });
            });
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\code\resources\views/accounting/reports/profit_loss.blade.php ENDPATH**/ ?>