

<?php
    $locale = app()->getLocale();
    $isRtl = $locale == 'ar';
?>

<?php $__env->startSection('content'); ?>
    <style>
        .stat-card-premium {
            padding: 25px;
            position: relative;
            overflow: hidden;
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 24px;
            background: rgba(13, 17, 23, 0.4);
            backdrop-filter: blur(20px);
            transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
            height: 100%;
        }

        .stat-card-premium:hover {
            transform: translateY(-10px) scale(1.02);
            border-color: rgba(255, 255, 255, 0.2);
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.4);
        }

        .stat-card-premium::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle at center, rgba(255, 255, 255, 0.03) 0%, transparent 70%);
            pointer-events: none;
        }

        .stat-icon-wrapper {
            width: 50px;
            height: 50px;
            border-radius: 16px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
            margin-bottom: 20px;
        }

        .stat-label-premium {
            color: #94a3b8;
            font-size: 0.85rem;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-bottom: 5px;
        }

        .stat-value-premium {
            font-size: 2rem;
            font-weight: 800;
            color: #fff;
            margin-bottom: 10px;
            font-family: 'Inter', sans-serif;
        }

        .stat-trend-premium {
            font-size: 0.8rem;
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 5px;
        }

        .quick-action-card {
            background: rgba(255, 255, 255, 0.03);
            border: 1px solid var(--glass-border);
            border-radius: 20px;
            padding: 25px;
            text-align: center;
            transition: all 0.3s ease;
            text-decoration: none;
            display: block;
        }

        .quick-action-card:hover {
            background: rgba(255, 255, 255, 0.08);
            border-color: var(--accent-purple);
            transform: translateY(-5px);
        }

        .quick-action-card i {
            font-size: 2rem;
            margin-bottom: 15px;
            display: block;
            background: linear-gradient(135deg, var(--accent-cyan), var(--accent-purple));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .quick-action-card span {
            color: #fff;
            font-weight: 600;
            font-size: 0.95rem;
        }

        .progress-slim {
            height: 6px;
            border-radius: 10px;
            background: rgba(255, 255, 255, 0.05);
            overflow: visible;
        }

        .progress-bar-animated-glow {
            position: relative;
            overflow: visible;
            box-shadow: 0 0 15px currentColor;
        }

        .mesh-gradient-1 {
            background-image: radial-gradient(at 0% 0%, hsla(199, 100%, 50%, 0.1) 0, transparent 50%), radial-gradient(at 50% 0%, hsla(250, 100%, 50%, 0.1) 0, transparent 50%);
        }

        .mesh-gradient-2 {
            background-image: radial-gradient(at 0% 0%, hsla(150, 100%, 50%, 0.1) 0, transparent 50%), radial-gradient(at 50% 0%, hsla(180, 100%, 50%, 0.1) 0, transparent 50%);
        }

        .chart-container-premium {
            background: rgba(13, 17, 23, 0.6);
            backdrop-filter: blur(20px);
            border: 1px solid var(--glass-border);
            border-radius: 24px;
            padding: 25px;
            height: 100%;
        }

        @media (max-width: 768px) {
            .chart-container-premium {
                padding: 15px;
            }

            .chart-container-premium canvas {
                max-height: 200px !important;
            }

            .stat-icon-wrapper {
                width: 40px;
                height: 40px;
                font-size: 1.2rem;
                margin-bottom: 10px;
            }
        }
    </style>

    <!-- Page Header -->
    <div class="row align-items-center mb-4 mb-md-5">
        <div class="col-md-8">
            <h1 class="display-6 fw-bold mb-1 animated-gradient-text"><?php echo e(__('Dashboard')); ?></h1>
            <p class="text-muted small fs-md-5"><?php echo e(__("Welcome back! Here's an overview of your business")); ?></p>
        </div>
        <div class="col-md-4 text-<?php echo e($isRtl ? 'start' : 'end'); ?> d-none d-md-block">
            <div class="glass-card p-3 d-inline-flex align-items-center gap-3">
                <div class="user-avatar"><?php echo e(substr(auth()->user()->name, 0, 1)); ?></div>
                <div class="text-start">
                    <div class="fw-bold text-white"><?php echo e(auth()->user()->name); ?></div>
                    <div class="small text-muted"><?php echo e(now()->format('l, d M Y')); ?></div>
                </div>
            </div>
        </div>
    </div>

    <!-- AI Insights Section (Compact) -->
    <?php if(isset($aiInsights) && count($aiInsights) > 0): ?>
        <div class="row mb-5">
            <div class="col-12">
                <div class="glass-card border-0 premium-shadow overflow-hidden"
                    style="background: linear-gradient(90deg, rgba(139, 92, 246, 0.1), rgba(0, 212, 255, 0.1));">
                    <div
                        class="px-4 py-3 border-bottom border-light border-opacity-10 d-flex align-items-center justify-content-between">
                        <h5 class="mb-0 text-white"><i
                                class="fas fa-sparkles text-warning me-2"></i><?php echo e(__('AI Auditor Insights')); ?></h5>
                        <span class="badge bg-purple rounded-pill px-3"><?php echo e(count($aiInsights)); ?>

                            <?php echo e(__('Alerts')); ?></span>
                    </div>
                    <div class="card-body p-0">
                        <div class="list-group list-group-flush">
                            <?php $__currentLoopData = $aiInsights; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $insight): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div
                                    class="list-group-item bg-transparent text-white border-light border-opacity-10 py-3 px-4 d-flex justify-content-between align-items-center hover-bg-light">
                                    <div class="d-flex align-items-center gap-3">
                                        <div
                                            class="p-2 rounded-circle bg-<?php echo e($insight['type'] == 'danger' ? 'danger' : 'warning'); ?> bg-opacity-20 text-<?php echo e($insight['type'] == 'danger' ? 'danger' : 'warning'); ?>">
                                            <i
                                                class="fas fa-<?php echo e($insight['type'] == 'danger' ? 'exclamation-circle' : 'info-circle'); ?>"></i>
                                        </div>
                                        <span><?php echo e($insight['message']); ?></span>
                                    </div>
                                    <?php if(isset($insight['action_link'])): ?>
                                        <a href="<?php echo e($insight['action_link']); ?>"
                                            class="btn btn-sm btn-link text-info text-decoration-none fw-bold"><?php echo e(__('Review')); ?>

                                            <i class="fas fa-arrow-right ms-1"></i></a>
                                    <?php endif; ?>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <!-- Main Stats Grid -->
    <div class="row g-3 mb-5">
        <div class="col-lg-3 col-6">
            <div class="stat-card-premium mesh-gradient-1">
                <div class="stat-icon-wrapper bg-info bg-opacity-10 text-info">
                    <i class="fas fa-users-viewfinder"></i>
                </div>
                <div class="stat-label-premium"><?php echo e(__('Total Customers')); ?></div>
                <div class="stat-value-premium"><?php echo e(number_format($stats['total_customers'] ?? 0)); ?></div>
                <div class="stat-trend-premium text-success">
                    <i class="fas fa-chevron-up"></i> 12% <?php echo e(__('Active')); ?>

                </div>
            </div>
        </div>
        <div class="col-lg-3 col-6">
            <div class="stat-card-premium mesh-gradient-2">
                <div class="stat-icon-wrapper bg-success bg-opacity-10 text-success">
                    <i class="fas fa-money-bill-trend-up"></i>
                </div>
                <div class="stat-label-premium">إجمالي الإيرادات (Revenue)</div>
                <div class="stat-value-premium"><?php echo e(number_format($stats['total_revenue'] ?? 0, 0)); ?> <small
                        class="fs-6 text-muted">EGP</small></div>
                <div class="stat-trend-premium text-success">
                    <i class="fas fa-check-circle"></i> Paid Only
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6">
            <div class="stat-card-premium">
                <div class="stat-icon-wrapper bg-warning bg-opacity-10 text-warning">
                    <i class="fas fa-briefcase"></i>
                </div>
                <div class="stat-label-premium"><?php echo e(__('Projects')); ?></div>
                <div class="stat-value-premium"><?php echo e($stats['active_projects'] ?? 0); ?></div>
                <div class="stat-trend-premium">
                    <div class="w-100">
                        <div class="d-flex justify-content-between mb-1">
                            <span class="small text-muted"><?php echo e(__('Avg Completion')); ?></span>
                            <span class="small text-white"><?php echo e(round($stats['avg_project_completion'] ?? 0)); ?>%</span>
                        </div>
                        <div class="progress progress-slim">
                            <div class="progress-bar bg-warning progress-bar-animated-glow"
                                style="width: <?php echo e($stats['avg_project_completion'] ?? 0); ?>%"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6">
            <div class="stat-card-premium">
                <div class="stat-icon-wrapper bg-purple bg-opacity-10 text-purple" style="color: #8b5cf6;">
                    <i class="fas fa-hand-holding-dollar"></i>
                </div>
                <div class="stat-label-premium"><?php echo e(__('Pending Commissions')); ?></div>
                <div class="stat-value-premium"><?php echo e(number_format($stats['pending_commissions'] ?? 0, 0)); ?></div>
                <div class="stat-trend-premium text-danger">
                    <i class="fas fa-clock"></i> Awaiting Payment
                </div>
            </div>
        </div>
    </div>

    <!-- Charts Row -->
    <div class="row g-4 mb-5">
        <div class="col-lg-8">
            <div class="chart-container-premium">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h5 class="text-white mb-0"><?php echo e(__('Financial Performance')); ?></h5>
                </div>
                <div style="height: 200px; max-height: 300px;">
                    <canvas id="revenueChart"></canvas>
                </div>
            </div>
        </div>
        <div class="col-lg-4">
            <div class="chart-container-premium">
                <h5 class="text-white mb-4"><?php echo e(__('Invoice Status')); ?></h5>
                <div style="height: 230px;">
                    <canvas id="invoiceStatusChart"></canvas>
                </div>
                <div class="mt-4 row g-2">
                    <div class="col-4 text-center">
                        <div class="small text-muted"><?php echo e(__('Paid')); ?></div>
                        <div class="fw-bold text-success"><?php echo e($invoiceStats['paid']); ?></div>
                    </div>
                    <div class="col-4 text-center border-start border-end border-light border-opacity-10">
                        <div class="small text-muted"><?php echo e(__('Pending')); ?></div>
                        <div class="fw-bold text-warning"><?php echo e($invoiceStats['unpaid']); ?></div>
                    </div>
                    <div class="col-4 text-center">
                        <div class="small text-muted"><?php echo e(__('Partial')); ?></div>
                        <div class="fw-bold text-info"><?php echo e($invoiceStats['partial']); ?></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Actions Grid -->
    <div class="mb-5">
        <h5 class="text-white mb-4"><i class="fas fa-bolt me-2 text-warning"></i><?php echo e(__('Quick Actions')); ?></h5>
        <div class="row g-4">
            <div class="col-md-3 col-6">
                <a href="<?php echo e(route('customers.create')); ?>" class="quick-action-card">
                    <i class="fas fa-user-plus"></i>
                    <span><?php echo e(__('New Customer')); ?></span>
                </a>
            </div>
            <div class="col-md-3 col-6">
                <a href="<?php echo e(route('accounting.invoices.create')); ?>" class="quick-action-card">
                    <i class="fas fa-file-invoice-dollar"></i>
                    <span><?php echo e(__('New Invoice')); ?></span>
                </a>
            </div>
            <div class="col-md-3 col-6">
                <a href="<?php echo e(route('accounting.bills.create')); ?>" class="quick-action-card">
                    <i class="fas fa-receipt"></i>
                    <span><?php echo e(__('Record Bill')); ?></span>
                </a>
            </div>
            <div class="col-md-3 col-6">
                <a href="<?php echo e(route('accounting.projects.index')); ?>" class="quick-action-card">
                    <i class="fas fa-diagram-project"></i>
                    <span><?php echo e(__('Manage Projects')); ?></span>
                </a>
            </div>
        </div>
    </div>

    <!-- Scripts for Charts -->
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            // Revenue Chart
            const ctxRevenue = document.getElementById('revenueChart').getContext('2d');
            new Chart(ctxRevenue, {
                type: 'line',
                data: {
                    labels: <?php echo json_encode($months); ?>,
                    datasets: [{
                        label: '<?php echo e(__('Revenue (EGP)')); ?>',
                        data: <?php echo json_encode($revenueData); ?>,
                        borderColor: '#00d4ff',
                        backgroundColor: 'rgba(0, 212, 255, 0.1)',
                        borderWidth: 3,
                        tension: 0.4,
                        fill: true,
                        pointBackgroundColor: '#00d4ff',
                        pointBorderColor: '#fff',
                        pointHoverRadius: 6
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: { display: false }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            grid: { color: 'rgba(255, 255, 255, 0.05)' },
                            ticks: { color: '#94a3b8' }
                        },
                        x: {
                            grid: { display: false },
                            ticks: { color: '#94a3b8' }
                        }
                    }
                }
            });

            // Invoice Status Chart
            const ctxInvoice = document.getElementById('invoiceStatusChart').getContext('2d');
            new Chart(ctxInvoice, {
                type: 'doughnut',
                data: {
                    labels: ['<?php echo e(__('Paid')); ?>', '<?php echo e(__('Pending')); ?>', '<?php echo e(__('Partial')); ?>'],
                    datasets: [{
                        data: [<?php echo e($invoiceStats['paid']); ?>, <?php echo e($invoiceStats['unpaid']); ?>, <?php echo e($invoiceStats['partial']); ?>],
                        backgroundColor: ['#10b981', '#fbbf24', '#00d4ff'],
                        borderWidth: 0,
                        hoverOffset: 10
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    cutout: '75%',
                    plugins: {
                        legend: { display: false }
                    }
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\code\resources\views/dashboard/index.blade.php ENDPATH**/ ?>