

<?php $__env->startSection('content'); ?>
    <div class="row mb-4">
        <div class="col-12 col-md-4">
            <h2 class="fw-light mb-0"><?php echo e(__('Project Management')); ?></h2>
            <p class="text-muted small"><?php echo e(__('Monitor active projects, progress, and programmer performance')); ?></p>
        </div>
        <div class="col-12 col-md-8 text-md-end">
            <a href="<?php echo e(route('accounting.projects.create')); ?>" class="btn btn-primary shadow-sm px-4">
                <i class="fas fa-plus-circle me-2"></i><?php echo e(__('New Project')); ?>

            </a>
        </div>
    </div>

    <!-- Stats Row -->
    <div class="row mb-4 g-3">
        <div class="col-6 col-lg-3">
            <div class="card stat-card h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="bg-primary bg-opacity-10 p-2 rounded-3">
                            <i class="fas fa-project-diagram text-primary fa-lg"></i>
                        </div>
                        <span class="text-muted small"><?php echo e(__('Active Projects')); ?></span>
                    </div>
                    <h3 class="mb-0 fw-bold"><?php echo e($stats['active_count']); ?></h3>
                    <div class="text-muted small mt-2"><?php echo e(__('Total')); ?>: <?php echo e($stats['total_count']); ?></div>
                </div>
            </div>
        </div>
        <div class="col-6 col-lg-3">
            <div class="card stat-card h-100 border-start border-4 border-success">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="bg-success bg-opacity-10 p-2 rounded-3">
                            <i class="fas fa-check-circle text-success fa-lg"></i>
                        </div>
                        <span class="text-muted small text-success"><?php echo e(__('Completed')); ?></span>
                    </div>
                    <h3 class="mb-0 fw-bold text-success"><?php echo e($stats['completed_count']); ?></h3>
                    <div class="progress mt-3" style="height: 4px;">
                        <div class="progress-bar bg-success"
                            style="width: <?php echo e($stats['total_count'] > 0 ? ($stats['completed_count'] / $stats['total_count']) * 100 : 0); ?>%">
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-6 col-lg-3">
            <div class="card stat-card h-100 border-start border-4 border-info">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="bg-info bg-opacity-10 p-2 rounded-3">
                            <i class="fas fa-tasks text-info fa-lg"></i>
                        </div>
                        <span class="text-muted small text-info"><?php echo e(__('Avg Progress')); ?></span>
                    </div>
                    <h3 class="mb-0 fw-bold text-info"><?php echo e(number_format($stats['avg_progress'], 1)); ?>%</h3>
                    <div class="progress mt-3" style="height: 4px;">
                        <div class="progress-bar bg-info" style="width: <?php echo e($stats['avg_progress']); ?>%"></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-6 col-lg-3">
            <div class="card stat-card h-100 border-start border-4 border-warning">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="bg-warning bg-opacity-10 p-2 rounded-3">
                            <i class="fas fa-dollar-sign text-warning fa-lg"></i>
                        </div>
                        <span class="text-muted small text-warning"><?php echo e(__('Total Value')); ?></span>
                    </div>
                    <h3 class="mb-0 fw-bold"><?php echo e(number_format($stats['total_value'], 2)); ?></h3>
                    <div class="text-muted small mt-2"><?php echo e(__('Project Portfolio')); ?></div>
                </div>
            </div>
        </div>
    </div>

    <div class="card bg-dark border-secondary">
        <div class="card-body p-0">
            <div class="table-responsive table-responsive-stack">
                <table class="table table-hover table-dark mb-0 align-middle">
                    <thead class="bg-black">
                        <tr>
                            <th><?php echo e(__('Project Name')); ?></th>
                            <th><?php echo e(__('Customer')); ?></th>
                            <th><?php echo e(__('Programmer')); ?></th>
                            <th><?php echo e(__('Progress')); ?></th>
                            <th><?php echo e(__('Status')); ?></th>
                            <th><?php echo e(__('Total Price')); ?></th>
                            <th class="text-end"><?php echo e(__('Actions')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td data-label="<?php echo e(__('Project Name')); ?>">
                                    <div class="fw-bold"><?php echo e($project->name); ?></div>
                                    <small
                                        class="text-muted"><?php echo e($project->start_date ? $project->start_date->format('M d, Y') : __('No Start Date')); ?></small>
                                </td>
                                <td data-label="<?php echo e(__('Customer')); ?>"><?php echo e($project->customer->name ?? __('Unknown Customer')); ?>

                                </td>
                                <td data-label="<?php echo e(__('Programmer')); ?>">
                                    <?php if($project->programmer): ?>
                                        <a href="<?php echo e(route('accounting.programmers.statement', $project->programmer)); ?>"
                                            class="text-info text-decoration-none">
                                            <?php echo e($project->programmer->name); ?>

                                        </a>
                                    <?php else: ?>
                                        <span class="text-muted"><?php echo e(__('Unknown Programmer')); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td data-label="<?php echo e(__('Progress')); ?>" style="width: 15%">
                                    <div class="progress bg-black" style="height: 10px;">
                                        <div class="progress-bar bg-success" role="progressbar"
                                            style="width: <?php echo e($project->progress_percent); ?>%"></div>
                                    </div>
                                    <small class="text-muted"><?php echo e($project->progress_percent); ?>% <?php echo e(__('Complete')); ?></small>
                                </td>
                                <td data-label="<?php echo e(__('Status')); ?>">
                                    <?php
                                        $color = match ($project->status) {
                                            'completed' => 'success',
                                            'in_progress' => 'info',
                                            'on_hold' => 'warning',
                                            'cancelled' => 'danger',
                                            default => 'secondary'
                                        };
                                    ?>
                                    <span class="badge bg-<?php echo e($color); ?>"><?php echo e(__($project->status)); ?></span>
                                </td>
                                <td data-label="<?php echo e(__('Total Price')); ?>" class="fw-bold">
                                    <?php echo e(number_format($project->total_price, 2)); ?>

                                </td>
                                <td data-label="<?php echo e(__('Actions')); ?>" class="text-end">
                                    <a href="<?php echo e(route('accounting.projects.show', $project)); ?>"
                                        class="btn btn-sm btn-outline-light">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="<?php echo e(route('accounting.projects.edit', $project)); ?>"
                                        class="btn btn-sm btn-outline-info">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete projects')): ?>
                                        <form action="<?php echo e(route('accounting.projects.destroy', $project)); ?>" method="POST"
                                            class="d-inline"
                                            onsubmit="return confirm('<?php echo e(__('Are you sure you want to delete this project?')); ?>')">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-sm btn-outline-danger" title="<?php echo e(__('Delete')); ?>">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    <?php endif; ?>
                                </td>

                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="7" class="text-center py-5 text-muted"><?php echo e(__('No projects found.')); ?></td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <div class="p-3">
                <?php echo e($projects->links()); ?>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\code\resources\views/accounting/projects/index.blade.php ENDPATH**/ ?>