

<?php $__env->startSection('content'); ?>
<div class="row mb-4 print-hide">
    <div class="col-12">
        <h2 class="fw-light"><?php echo e(__('Customer Account Statement')); ?></h2>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('accounting.reports.index')); ?>"><?php echo e(__('Reports')); ?></a></li>
                <li class="breadcrumb-item active"><?php echo e(__('Customer Statement')); ?></li>
            </ol>
        </nav>
    </div>
</div>

<div class="card mb-4 print-hide">
    <div class="card-body">
        <form action="<?php echo e(route('accounting.reports.customer_statement')); ?>" method="GET" class="row g-3 align-items-end">
            <div class="col-md-6">
                <label class="form-label"><?php echo e(__('Select Customer')); ?></label>
                <select name="customer_id" class="form-select" required>
                    <option value="">-- <?php echo e(__('Choose Customer')); ?> --</option>
                    <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($c->id); ?>" <?php echo e(isset($selectedCustomer) && $selectedCustomer->id == $c->id ? 'selected' : ''); ?>>
                            <?php echo e($c->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label"><?php echo e(__('Start Date')); ?></label>
                <input type="date" name="start_date" class="form-control" value="<?php echo e(request('start_date', date('Y-01-01'))); ?>">
            </div>
            <div class="col-md-3">
                <button type="submit" class="btn btn-primary w-100"><i class="fas fa-search me-2"></i><?php echo e(__('Display')); ?></button>
            </div>
        </form>
    </div>
</div>

<?php if($selectedCustomer): ?>
<div class="card">
    <div class="card-header bg-dark border-secondary d-flex justify-content-between align-items-center">
        <h5 class="mb-0"><?php echo e(__('Statement for:')); ?> <span class="text-primary"><?php echo e($selectedCustomer->name); ?></span></h5>
        <a href="<?php echo e(route('accounting.reports.customer_statement.print', ['customer_id' => $selectedCustomer->id, 'start_date' => request('start_date'), 'end_date' => request('end_date')])); ?>" target="_blank" class="btn btn-sm btn-outline-light print-hide"><i class="fas fa-print"></i> <?php echo e(__('Premium A4 Print')); ?></a>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover table-striped mb-0">
                <thead class="table-dark">
                    <tr>
                        <th><?php echo e(__('Date')); ?></th>
                        <th><?php echo e(__('Type')); ?></th>
                        <th><?php echo e(__('Reference')); ?></th>
                        <th><?php echo e(__('Description')); ?></th>
                        <th class="text-end"><?php echo e(__('Debit (Bill)')); ?></th>
                        <th class="text-end"><?php echo e(__('Credit (Pay)')); ?></th>
                        <th class="text-end"><?php echo e(__('Balance')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $balance = 0; ?>
                    <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trans): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php 
                            $balance += ($trans['debit'] - $trans['credit']); 
                        ?>
                        <tr>
                            <td><?php echo e(\Carbon\Carbon::parse($trans['date'])->format('Y-m-d')); ?></td>
                            <td><span class="badge <?php echo e($trans['type'] == 'Invoice' ? 'bg-primary' : 'bg-success'); ?>"><?php echo e($trans['type']); ?></span></td>
                            <td><?php echo e($trans['ref']); ?></td>
                            <td><?php echo e($trans['description']); ?></td>
                            <td class="text-end"><?php echo e($trans['debit'] > 0 ? number_format($trans['debit'], 2) : '-'); ?></td>
                            <td class="text-end"><?php echo e($trans['credit'] > 0 ? number_format($trans['credit'], 2) : '-'); ?></td>
                            <td class="text-end fw-bold"><?php echo e(number_format($balance, 2)); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
                <tfoot class="table-dark">
                    <tr>
                        <th colspan="6" class="text-end"><?php echo e(__('Ending Balance:')); ?></th>
                        <th class="text-end <?php echo e($balance > 0 ? 'text-danger' : 'text-success'); ?>"><?php echo e(number_format($balance, 2)); ?></th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</div>
<?php endif; ?>

<style>
@media print {
    .print-hide { display: none !important; }
    .card { border: none !important; }
    body { background-color: #fff !important; color: #000 !important; }
    .table-dark { color: #000 !important; background-color: transparent !important; border-bottom: 2px solid #000; }
    .text-white { color: #000 !important; }
}
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\code\resources\views/accounting/reports/customer_statement.blade.php ENDPATH**/ ?>