

<?php $__env->startSection('content'); ?>
    <!-- Page Header -->
    <div class="page-header d-flex justify-content-between align-items-center flex-wrap gap-3">
        <div>
            <h1 class="page-title"><?php echo e(__('Sales Team')); ?></h1>
            <p class="page-subtitle"><?php echo e(__('Manage your sales representatives and track their performance')); ?></p>
        </div>
        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addSalesPersonModal">
            <i class="fas fa-plus me-2"></i><?php echo e(__('Add Sales Person')); ?>

        </button>
    </div>

    <!-- Stats Row -->
    <div class="row g-2 g-md-4 mb-4">
        <div class="col-6 col-lg-3">
            <div class="stat-card stat-card-premium cyan">
                <div class="stat-icon-wrapper"><i class="fas fa-users"></i></div>
                <div class="stat-value"><?php echo e($salesPeople->count()); ?></div>
                <div class="stat-label"><?php echo e(__('Total Members')); ?></div>
            </div>
        </div>
        <div class="col-6 col-lg-3">
            <div class="stat-card stat-card-premium green">
                <div class="stat-icon-wrapper"><i class="fas fa-user-check"></i></div>
                <div class="stat-value"><?php echo e($salesPeople->where('is_active', true)->count()); ?></div>
                <div class="stat-label"><?php echo e(__('Active')); ?></div>
            </div>
        </div>
        <div class="col-6 col-lg-3">
            <div class="stat-card stat-card-premium orange">
                <div class="stat-icon-wrapper"><i class="fas fa-user-clock"></i></div>
                <div class="stat-value"><?php echo e($salesPeople->where('is_active', false)->count()); ?></div>
                <div class="stat-label"><?php echo e(__('Inactive')); ?></div>
            </div>
        </div>
        <div class="col-6 col-lg-3">
            <div class="stat-card stat-card-premium purple">
                <div class="stat-icon-wrapper"><i class="fas fa-coins"></i></div>
                <div class="stat-value"><?php echo e(number_format($salesPeople->sum('balance'), 0, '.', ',')); ?></div>
                <div class="stat-label"><?php echo e(__('Total Balance (EGP)')); ?></div>
            </div>
        </div>
    </div>

    <div class="row">
        <?php $__currentLoopData = $salesPeople; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-md-4 mb-4">
                <div class="card h-100 border-top border-4 border-<?php echo e($sp->is_active ? 'info' : 'secondary'); ?>">
                    <div class="card-body">
                        <div class="d-flex justify-content-between mb-3">
                            <h5 class="card-title fw-bold">
                                <?php echo e($sp->name); ?>

                                <a href="<?php echo e(route('accounting.sales-people.edit', $sp)); ?>" class="text-warning ms-2"><i
                                        class="fas fa-edit fa-xs"></i></a>
                            </h5>
                            <span
                                class="badge bg-<?php echo e($sp->is_active ? 'info' : 'secondary'); ?>"><?php echo e($sp->is_active ? __('Active') : __('Inactive')); ?></span>
                        </div>
                        <div class="mb-2"><i class="fas fa-phone me-2 text-muted"></i><?php echo e($sp->phone ?: '-'); ?></div>
                        <div class="mb-2"><i class="fab fa-whatsapp me-2 text-success"></i><?php echo e($sp->whatsapp ?: '-'); ?></div>
                        <div class="mb-3"><i class="fas fa-envelope me-2 text-muted"></i><?php echo e($sp->email ?: '-'); ?></div>

                        <div class="d-flex justify-content-between align-items-center bg-dark p-2 rounded mb-3">
                            <span class="small text-muted text-uppercase"><?php echo e(__('Current Balance:')); ?></span>
                            <span class="fw-bold <?php echo e($sp->balance > 0 ? 'text-danger' : 'text-success'); ?>">
                                <?php echo e(number_format($sp->balance, 2)); ?> EGP
                            </span>
                        </div>

                        <div class="row g-2">
                            <div class="col-6">
                                <a href="<?php echo e(route('accounting.sales-people.show', $sp)); ?>"
                                    class="btn btn-outline-info w-100 btn-sm"><?php echo e(__('Financials')); ?></a>
                            </div>
                            <div class="col-6">
                                <a href="<?php echo e(route('accounting.sales-people.print-statement', $sp)); ?>" target="_blank"
                                    class="btn btn-outline-light w-100 btn-sm"><?php echo e(__('Statement')); ?></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <!-- Add Modal -->
    <div class="modal fade" id="addSalesPersonModal" tabindex="-1">
        <div class="modal-dialog">
            <form action="<?php echo e(route('accounting.sales-people.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-content bg-dark border-secondary">
                    <div class="modal-header border-secondary">
                        <h5 class="modal-title"><?php echo e(__('New Sales Person')); ?></h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label"><?php echo e(__('Full Name')); ?></label>
                            <input type="text" name="name" class="form-control" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label"><?php echo e(__('Phone')); ?></label>
                            <input type="text" name="phone" class="form-control">
                        </div>
                        <div class="mb-3">
                            <label class="form-label"><?php echo e(__('WhatsApp Number')); ?></label>
                            <input type="text" name="whatsapp" class="form-control"
                                placeholder="<?php echo e(__('With country code, e.g. 201...')); ?>">
                        </div>
                        <div class="mb-3">
                            <label class="form-label"><?php echo e(__('Email')); ?></label>
                            <input type="email" name="email" class="form-control">
                        </div>
                    </div>
                    <div class="modal-footer border-secondary">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo e(__('Save Member')); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\code\resources\views/accounting/sales_people/index.blade.php ENDPATH**/ ?>