

<?php $__env->startSection('content'); ?>
    <div class="row mb-4">
        <div class="col-12 col-md-6">
            <h2 class="fw-light"><?php echo e(__('Subscriptions (Recurring Invoices)')); ?></h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
                    <li class="breadcrumb-item active"><?php echo e(__('Subscriptions')); ?></li>
                </ol>
            </nav>
        </div>
        <div class="col-12 col-md-6 text-md-end">
            <a href="<?php echo e(route('accounting.recurring.create')); ?>" class="btn btn-primary">
                <i class="fas fa-plus-circle me-2"></i><?php echo e(__('New Subscription')); ?>

            </a>
        </div>
    </div>

    <div class="card">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead class="table-dark">
                        <tr>
                            <th><?php echo e(__('Title')); ?></th>
                            <th><?php echo e(__('Customer')); ?></th>
                            <th><?php echo e(__('Frequency')); ?></th>
                            <th><?php echo e(__('Next Run')); ?></th>
                            <th class="text-end"><?php echo e(__('Amount')); ?></th>
                            <th class="text-center"><?php echo e(__('Status')); ?></th>
                            <th><?php echo e(__('Actions')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $recurringInvoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td class="fw-bold"><?php echo e($sub->title); ?></td>
                                <td><?php echo e($sub->customer->name); ?></td>
                                <td><span class="badge bg-info text-dark"><?php echo e(__($sub->frequency)); ?></span></td>
                                <td>
                                    <?php echo e($sub->next_run_date->format('Y-m-d')); ?>

                                    <?php if($sub->next_run_date->isPast() && $sub->is_active): ?>
                                        <span class="text-danger ms-1"><i class="fas fa-exclamation-circle"></i> <?php echo e(__('Due')); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td class="text-end fw-bold"><?php echo e(number_format($sub->amount, 2)); ?></td>
                                <td class="text-center">
                                    <?php if($sub->is_active): ?>
                                        <span class="badge bg-success"><?php echo e(__('Active')); ?></span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary"><?php echo e(__('Inactive')); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('accounting.recurring.edit', $sub)); ?>"
                                        class="btn btn-sm btn-outline-warning">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="7" class="text-center py-5">
                                    <i class="fas fa-sync fa-3x text-muted mb-3"></i>
                                    <h3><?php echo e(__('No subscriptions found')); ?></h3>
                                    <p class="text-muted"><?php echo e(__('Create a subscription to automatically generate invoices.')); ?></p>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php if($recurringInvoices->hasPages()): ?>
            <div class="card-footer">
                <?php echo e($recurringInvoices->links()); ?>

            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\code\resources\views/accounting/recurring/index.blade.php ENDPATH**/ ?>