

<?php $__env->startSection('content'); ?>
    <div class="row mb-4">
        <div class="col-12 col-md-6">
            <h2 class="fw-light"><?php echo e(__('Partners Management')); ?></h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('Partners')); ?></li>
                </ol>
            </nav>
        </div>
        <div class="col-12 col-md-6 text-md-end">
            <a href="<?php echo e(route('accounting.partners.calculate')); ?>" class="btn btn-info text-white">
                <i class="fas fa-calculator me-2"></i><?php echo e(__('Calculate Profits')); ?>

            </a>
            <a href="<?php echo e(route('accounting.partners.create')); ?>" class="btn btn-primary ms-2">
                <i class="fas fa-plus-circle me-2"></i><?php echo e(__('Add Partner')); ?>

            </a>
        </div>
    </div>

    <div class="row mb-4">
        <div class="col-md-4">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <h6 class="card-title opacity-75"><?php echo e(__('Total Ownership')); ?></h6>
                    <h3 class="mb-0"><?php echo e($partners->sum('ownership_percent')); ?>%</h3>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <h6 class="card-title opacity-75"><?php echo e(__('Total Capital Invested')); ?></h6>
                    <h3 class="mb-0"><?php echo e(number_format($partners->sum('capital_invested'), 2)); ?> EGP</h3>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card bg-info text-white">
                <div class="card-body">
                    <h6 class="card-title opacity-75"><?php echo e(__('Total Partners')); ?></h6>
                    <h3 class="mb-0"><?php echo e($partners->count()); ?></h3>
                </div>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0 align-middle">
                    <thead class="table-dark">
                        <tr>
                            <th><?php echo e(__('Partner Name')); ?></th>
                            <th><?php echo e(__('Ownership %')); ?></th>
                            <th><?php echo e(__('Capital Invested')); ?></th>
                            <th><?php echo e(__('Distributions')); ?></th>
                            <th><?php echo e(__('Status')); ?></th>
                            <th class="text-end"><?php echo e(__('Actions')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $partners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $partner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <div class="fw-bold"><?php echo e($partner->name); ?></div>
                                    <div class="small text-muted"><?php echo e($partner->email); ?></div>
                                </td>
                                <td>
                                    <div class="progress" style="height: 10px; width: 100px;">
                                        <div class="progress-bar" role="progressbar"
                                            style="width: <?php echo e($partner->ownership_percent); ?>%"></div>
                                    </div>
                                    <small><?php echo e($partner->ownership_percent); ?>%</small>
                                </td>
                                <td><?php echo e(number_format($partner->capital_invested, 2)); ?> EGP</td>
                                <td>
                                    <span class="badge bg-secondary"><?php echo e($partner->profit_distributions_count); ?>

                                        <?php echo e(__('Times')); ?></span>
                                    Filter
                                </td>
                                <td>
                                    <?php if($partner->is_active): ?>
                                        <span class="badge bg-success"><?php echo e(__('Active')); ?></span>
                                    <?php else: ?>
                                        <span class="badge bg-danger"><?php echo e(__('Inactive')); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td class="text-end">
                                    <div class="btn-group">
                                        <a href="<?php echo e(route('accounting.partners.edit', $partner)); ?>"
                                            class="btn btn-sm btn-outline-light">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="<?php echo e(route('accounting.partners.destroy', $partner)); ?>" method="POST"
                                            class="d-inline" onsubmit="return confirm('<?php echo e(__('Delete this partner?')); ?>')">
                                            <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-sm btn-outline-danger border-0">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="6" class="text-center py-5 text-muted"><?php echo e(__('No partners found.')); ?></td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\code\resources\views/accounting/partners/index.blade.php ENDPATH**/ ?>