

<?php $__env->startSection('content'); ?>
<div class="row mb-4">
    <div class="col-12 col-md-4">
        <h2 class="fw-light mb-0"><?php echo e(__('Invoices')); ?></h2>
        <p class="text-muted small"><?php echo e(__('Manage billing, payments, and client receivables')); ?></p>
    </div>
    <div class="col-12 col-md-8 text-md-end">
        <a href="<?php echo e(route('accounting.invoices.sync-whmcs')); ?>" class="btn btn-outline-info me-2">
            <i class="fas fa-sync me-2"></i><?php echo e(__('Sync WHMCS')); ?>

        </a>
        <a href="<?php echo e(route('accounting.invoices.create')); ?>" class="btn btn-primary shadow-sm px-4">
            <i class="fas fa-plus-circle me-2"></i><?php echo e(__('New Invoice')); ?>

        </a>
    </div>
</div>

<!-- Stats Row -->
<div class="row mb-4 g-3">
    <div class="col-6 col-lg-3">
        <div class="card stat-card h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <div class="bg-primary bg-opacity-10 p-2 rounded-3">
                        <i class="fas fa-file-invoice text-primary fa-lg"></i>
                    </div>
                    <span class="text-muted small"><?php echo e(__('Total Invoices')); ?></span>
                </div>
                <h3 class="mb-0 fw-bold"><?php echo e($stats['total_count']); ?></h3>
                <div class="text-muted small mt-2"><?php echo e(__('Value')); ?>: <?php echo e(number_format($stats['total_value'], 2)); ?></div>
            </div>
        </div>
    </div>
    <div class="col-6 col-lg-3">
        <div class="card stat-card h-100 border-start border-4 border-success">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <div class="bg-success bg-opacity-10 p-2 rounded-3">
                        <i class="fas fa-money-check-dollar text-success fa-lg"></i>
                    </div>
                    <span class="text-muted small text-success"><?php echo e(__('Collected')); ?></span>
                </div>
                <h3 class="mb-0 fw-bold text-success"><?php echo e(number_format($stats['paid_value'], 2)); ?></h3>
                <div class="progress mt-3" style="height: 4px;">
                    <div class="progress-bar bg-success" style="width: <?php echo e($stats['total_value'] > 0 ? ($stats['paid_value'] / $stats['total_value']) * 100 : 0); ?>%"></div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-6 col-lg-3">
        <div class="card stat-card h-100 border-start border-4 border-danger">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <div class="bg-danger bg-opacity-10 p-2 rounded-3">
                        <i class="fas fa-clock text-danger fa-lg"></i>
                    </div>
                    <span class="text-muted small text-danger"><?php echo e(__('Pending')); ?></span>
                </div>
                <h3 class="mb-0 fw-bold text-danger"><?php echo e(number_format($stats['pending_value'], 2)); ?></h3>
                <div class="progress mt-3" style="height: 4px;">
                    <div class="progress-bar bg-danger" style="width: <?php echo e($stats['total_value'] > 0 ? ($stats['pending_value'] / $stats['total_value']) * 100 : 0); ?>%"></div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-6 col-lg-3">
        <div class="card stat-card h-100 border-start border-4 border-info">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <div class="bg-info bg-opacity-10 p-2 rounded-3">
                        <i class="fas fa-calendar-day text-info fa-lg"></i>
                    </div>
                    <span class="text-muted small text-info"><?php echo e(__('Due Today')); ?></span>
                </div>
                <h3 class="mb-0 fw-bold"><?php echo e($stats['due_today_count']); ?></h3>
                <div class="text-muted small mt-2"><?php echo e(__('Value')); ?>: <?php echo e(number_format($stats['due_today_value'], 2)); ?></div>
            </div>
        </div>
    </div>
</div>

<!-- Filter Tabs -->
<div class="card mb-4">
    <div class="card-body py-2">
        <div class="d-flex flex-wrap gap-2 align-items-center">
        <div class="d-flex flex-wrap gap-2 align-items-center mb-2">
            <span class="text-muted small me-2"><?php echo e(__('Filter by Status')); ?>:</span>
            <a href="<?php echo e(route('accounting.invoices.index', array_merge(request()->except('status'), []))); ?>" 
               class="btn btn-sm <?php echo e(!request('status') ? 'btn-primary' : 'btn-outline-secondary'); ?>">
                <?php echo e(__('All')); ?> <span class="badge bg-light text-dark ms-1"><?php echo e($statusCounts['all'] ?? 0); ?></span>
            </a>
            <a href="<?php echo e(route('accounting.invoices.index', array_merge(request()->all(), ['status' => 'unpaid']))); ?>" 
               class="btn btn-sm <?php echo e(request('status') == 'unpaid' ? 'btn-warning' : 'btn-outline-warning'); ?>">
                <?php echo e(__('Unpaid')); ?> <span class="badge bg-light text-dark ms-1"><?php echo e($statusCounts['unpaid'] ?? 0); ?></span>
            </a>
            <a href="<?php echo e(route('accounting.invoices.index', array_merge(request()->all(), ['status' => 'partial']))); ?>" 
               class="btn btn-sm <?php echo e(request('status') == 'partial' ? 'btn-info' : 'btn-outline-info'); ?>">
                <?php echo e(__('Partial')); ?> <span class="badge bg-light text-dark ms-1"><?php echo e($statusCounts['partial'] ?? 0); ?></span>
            </a>
            <a href="<?php echo e(route('accounting.invoices.index', array_merge(request()->all(), ['status' => 'paid']))); ?>" 
               class="btn btn-sm <?php echo e(request('status') == 'paid' ? 'btn-success' : 'btn-outline-success'); ?>">
                <?php echo e(__('Paid')); ?> <span class="badge bg-light text-dark ms-1"><?php echo e($statusCounts['paid'] ?? 0); ?></span>
            </a>
            <a href="<?php echo e(route('accounting.invoices.index', array_merge(request()->all(), ['status' => 'cancelled']))); ?>" 
               class="btn btn-sm <?php echo e(request('status') == 'cancelled' ? 'btn-danger' : 'btn-outline-danger'); ?>">
                <?php echo e(__('Cancelled')); ?> <span class="badge bg-light text-dark ms-1"><?php echo e($statusCounts['cancelled'] ?? 0); ?></span>
            </a>
            <a href="<?php echo e(route('accounting.invoices.index', array_merge(request()->all(), ['status' => 'draft']))); ?>" 
               class="btn btn-sm <?php echo e(request('status') == 'draft' ? 'btn-secondary' : 'btn-outline-secondary'); ?>">
                <?php echo e(__('Draft')); ?> <span class="badge bg-light text-dark ms-1"><?php echo e($statusCounts['draft'] ?? 0); ?></span>
            </a>
        </div>
        <div class="d-flex flex-wrap gap-2 align-items-center">
            <span class="text-muted small me-2"><?php echo e(__('Filter by Tax Type')); ?>:</span>
            <a href="<?php echo e(route('accounting.invoices.index', array_merge(request()->except('is_tax_invoice'), []))); ?>" 
               class="btn btn-sm <?php echo e(request('is_tax_invoice') === null ? 'btn-primary' : 'btn-outline-secondary'); ?>">
                <?php echo e(__('All Invoices')); ?>

            </a>
            <a href="<?php echo e(route('accounting.invoices.index', array_merge(request()->all(), ['is_tax_invoice' => 0]))); ?>" 
               class="btn btn-sm <?php echo e(request('is_tax_invoice') === '0' ? 'btn-info' : 'btn-outline-info'); ?>">
                <?php echo e(__('Normal Invoices')); ?>

            </a>
            <a href="<?php echo e(route('accounting.invoices.index', array_merge(request()->all(), ['is_tax_invoice' => 1]))); ?>" 
               class="btn btn-sm <?php echo e(request('is_tax_invoice') === '1' ? 'btn-danger' : 'btn-outline-danger'); ?>">
                <i class="fas fa-file-invoice-dollar me-1"></i> <?php echo e(__('Show Only Tax Invoices')); ?>

            </a>
        </div>
        </div>
    </div>
</div>

<div class="card">

    <div class="card-body p-0">
        <div class="table-responsive table-responsive-stack">
            <table class="table table-hover align-middle mb-0">
                <thead class="table-dark">
                    <tr>
                        <th><?php echo e(__('Status')); ?></th>
                        <th><?php echo e(__('Code')); ?></th>
                        <th><?php echo e(__('Client')); ?></th>
                        <th><?php echo e(__('Salesperson')); ?></th>
                        <th><?php echo e(__('Date')); ?></th>
                        <th><?php echo e(__('Due Date')); ?></th>
                        <th class="text-end"><?php echo e(__('Amount')); ?></th>
                        <th><?php echo e(__('Last Updated')); ?></th>
                        <th class="text-end"><?php echo e(__('Actions')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td data-label="<?php echo e(__('Status')); ?>">
                            <?php switch($invoice->status):
                                case ('paid'): ?>
                                    <span class="badge bg-success"><?php echo e(__('paid')); ?></span>
                                    <?php break; ?>
                                <?php case ('partial'): ?>
                                    <span class="badge bg-info text-dark"><?php echo e(__('partial')); ?></span>
                                    <?php break; ?>
                                <?php case ('draft'): ?>
                                    <span class="badge bg-secondary"><?php echo e(__('draft')); ?></span>
                                    <?php break; ?>
                                <?php case ('sent'): ?>
                                    <span class="badge bg-primary"><?php echo e(__('sent')); ?></span>
                                    <?php break; ?>
                                <?php case ('cancelled'): ?>
                                    <span class="badge bg-danger"><?php echo e(__('cancelled')); ?></span>
                                    <?php break; ?>
                            <?php endswitch; ?>
                        </td>
                        <td data-label="<?php echo e(__('Code')); ?>" class="fw-bold"><?php echo e($invoice->code); ?></td>
                        <td data-label="<?php echo e(__('Client')); ?>">
                            <a href="<?php echo e(route('customers.show', $invoice->customer_id)); ?>" class="text-decoration-none text-light">
                                <?php echo e($invoice->customer->name); ?>

                            </a>
                        </td>
                        <td data-label="<?php echo e(__('Salesperson')); ?>">
                            <?php if($invoice->sales_person_id): ?>
                                <small><a href="<?php echo e(route('accounting.sales-people.show', $invoice->sales_person_id)); ?>" class="text-info"><?php echo e($invoice->salesPerson->name); ?></a></small>
                            <?php else: ?>
                                <span class="text-muted small">-</span>
                            <?php endif; ?>
                        </td>
                        <td data-label="<?php echo e(__('Date')); ?>"><?php echo e($invoice->date->format('Y-m-d')); ?></td>
                        <td data-label="<?php echo e(__('Due Date')); ?>">
                            <?php if($invoice->due_date): ?>
                                <span class="<?php echo e($invoice->due_date->isPast() && $invoice->status != 'paid' ? 'text-danger fw-bold' : ''); ?>">
                                    <?php echo e($invoice->due_date->format('Y-m-d')); ?>

                                </span>
                            <?php else: ?>
                                -
                            <?php endif; ?>
                        </td>
                        <td data-label="<?php echo e(__('Amount')); ?>" class="text-end fw-bold"><?php echo e(number_format($invoice->total, 2)); ?></td>
                        <td data-label="<?php echo e(__('Last Updated')); ?>" class="small text-muted"><?php echo e($invoice->updated_at->diffForHumans()); ?></td>
                        <td data-label="<?php echo e(__('Actions')); ?>" class="text-end">
                            <a href="<?php echo e(route('accounting.invoices.show', $invoice)); ?>" class="btn btn-sm btn-outline-light">
                                <i class="fas fa-eye"></i>
                            </a>
                            <?php if($invoice->status != 'paid'): ?>
                            <a href="<?php echo e(route('accounting.invoices.edit', $invoice)); ?>" class="btn btn-sm btn-outline-warning">
                                <i class="fas fa-edit"></i>
                            </a>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete invoices')): ?>
                            <form action="<?php echo e(route('accounting.invoices.destroy', $invoice)); ?>" method="POST" class="d-inline"
                                  onsubmit="return confirm('<?php echo e(__('Are you sure you want to delete this invoice?')); ?>')">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-sm btn-outline-danger" title="<?php echo e(__('Delete')); ?>">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                            <?php endif; ?>
                        </td>

                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="8" class="text-center py-5">
                            <i class="fas fa-file-invoice-dollar fa-3x text-muted mb-3"></i>
                            <h3><?php echo e(__('No invoices found')); ?></h3>
                            <p class="text-muted"><?php echo e(__('Create your first invoice to get started.')); ?></p>
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php if($invoices->hasPages()): ?>
    <div class="card-footer">
        <?php echo e($invoices->links()); ?>

    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\code\resources\views/accounting/invoices/index.blade.php ENDPATH**/ ?>