

<?php $__env->startSection('content'); ?>
    <div class="row mb-4">
        <div class="col-12 col-md-6">
            <h2 class="fw-light">Project: <?php echo e($project->name); ?></h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(route('accounting.projects.index')); ?>"><?php echo e(__('Projects')); ?></a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e($project->name); ?></li>
                </ol>
            </nav>
        </div>
        <div class="col-12 col-md-6 text-md-end">
            <button class="btn btn-outline-success me-2" data-bs-toggle="modal" data-bs-target="#updateProgressModal">
                <i class="fas fa-tasks me-2"></i>Update Progress
            </button>
            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#recordPaymentModal">
                <i class="fas fa-hand-holding-usd me-2"></i>Record Payout
            </button>
        </div>
    </div>

    <div class="row">
        <!-- Project Stats -->
        <div class="col-md-8">
            <!-- Project Stats -->
            <div class="row mb-4">
                <div class="col-md-4">
                    <div class="card bg-success text-white h-100">
                        <div class="card-body">
                            <h6 class="card-title text-light"><i
                                    class="fas fa-arrow-down me-2"></i><?php echo e(__('Collected Income')); ?></h6>
                            <h3><?php echo e(number_format($project->transactions->where('type', 'in')->sum('amount'), 2)); ?> EGP</h3>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card bg-danger text-white h-100">
                        <div class="card-body">
                            <h6 class="card-title text-light"><i class="fas fa-arrow-up me-2"></i><?php echo e(__('Total Expenses')); ?>

                            </h6>
                            <h3><?php echo e(number_format($project->transactions->where('type', 'out')->sum('amount'), 2)); ?> EGP</h3>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card bg-info text-white h-100">
                        <div class="card-body">
                            <h6 class="card-title text-light"><i class="fas fa-chart-line me-2"></i><?php echo e(__('Net Profit')); ?>

                            </h6>
                            <h3><?php echo e(number_format($project->transactions->where('type', 'in')->sum('amount') - $project->transactions->where('type', 'out')->sum('amount'), 2)); ?>

                                EGP</h3>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card bg-dark border-secondary mb-4">
                <div class="card-header bg-black text-white py-3">
                    <h5 class="mb-0">Project Overview</h5>
                </div>
                <div class="card-body">
                    <div class="row mb-4 text-center">
                        <div class="col-md-3">
                            <h6 class="text-muted">Total Price</h6>
                            <h4><?php echo e(number_format($project->total_price, 2)); ?> EGP</h4>
                        </div>
                        <div class="col-md-3">
                            <h6 class="text-muted">Commission</h6>
                            <h4 class="text-info"><?php echo e(number_format($project->commission_amount, 2)); ?> EGP</h4>
                        </div>
                        <div class="col-md-3">
                            <h6 class="text-muted">Paid to Developer</h6>
                            <h4 class="text-success"><?php echo e(number_format($project->paid_to_programmer, 2)); ?> EGP</h4>
                        </div>
                        <div class="col-md-3">
                            <h6 class="text-muted">Due Balance</h6>
                            <h4 class="text-danger"><?php echo e(number_format($project->remaining_programmer_balance, 2)); ?> EGP</h4>
                        </div>
                    </div>

                    <div class="mb-4">
                        <label class="form-label text-muted d-block">Progress (<?php echo e($project->progress_percent); ?>%)</label>
                        <div class="progress bg-black" style="height: 25px;">
                            <div class="progress-bar bg-success progress-bar-striped progress-bar-animated"
                                role="progressbar" style="width: <?php echo e($project->progress_percent); ?>%">
                                <?php echo e($project->progress_percent); ?>%
                            </div>
                        </div>
                    </div>

                    <hr class="border-secondary">

                    <h6>Details & Notes:</h6>
                    <div class="p-3 bg-black rounded text-light">
                        <?php echo nl2br(e($project->notes ?: 'No description provided.')); ?>

                    </div>
                </div>
            </div>

            <!-- Payment History -->
            <div class="card bg-dark border-secondary">
                <div class="card-header bg-black text-white">
                    <h5 class="mb-0">Programmer Payout History</h5>
                </div>
                <div class="card-body p-0">
                    <table class="table table-dark table-hover mb-0">
                        <thead class="bg-black">
                            <tr>
                                <th>Date</th>
                                <th>Amount</th>
                                <th>Recorded By</th>
                                <th>Notes</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $project->payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($payment->date->format('Y-m-d')); ?></td>
                                    <td class="fw-bold text-success"><?php echo e(number_format($payment->amount, 2)); ?> EGP</td>
                                    <td><?php echo e($payment->recorder->name); ?></td>
                                    <td><?php echo e($payment->notes); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="4" class="text-center py-4 text-muted">No payouts recorded yet.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Financial Transactions -->
            <div class="card bg-dark border-secondary mt-4">
                <div class="card-header bg-black text-white d-flex justify-content-between align-items-center">
                    <h5 class="mb-0"><?php echo e(__('Financial Transactions (Detailed)')); ?></h5>
                    <span class="badge bg-secondary"><?php echo e($project->transactions->count()); ?></span>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-dark table-hover mb-0">
                            <thead class="bg-black">
                                <tr>
                                    <th><?php echo e(__('Date')); ?></th>
                                    <th><?php echo e(__('Type')); ?></th>
                                    <th><?php echo e(__('Category')); ?></th>
                                    <th><?php echo e(__('Description')); ?></th>
                                    <th><?php echo e(__('Amount')); ?></th>
                                    <th><?php echo e(__('Treasury')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $project->transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($transaction->date->format('Y-m-d')); ?></td>
                                        <td>
                                            <?php if($transaction->type == 'in'): ?>
                                                <span class="badge bg-success">Income</span>
                                            <?php else: ?>
                                                <span class="badge bg-danger">Expense</span>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($transaction->category->name ?? 'N/A'); ?></td>
                                        <td><?php echo e($transaction->description); ?></td>
                                        <td class="<?php echo e($transaction->type == 'in' ? 'text-success' : 'text-danger'); ?> fw-bold">
                                            <?php echo e($transaction->type == 'in' ? '+' : '-'); ?><?php echo e(number_format($transaction->amount, 2)); ?>

                                        </td>
                                        <td><?php echo e($transaction->treasury->name); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="6" class="text-center py-4 text-muted">
                                            <?php echo e(__('No financial transactions recorded.')); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Sidebar Info -->
        <div class="col-md-4">
            <div class="card bg-dark border-secondary mb-4">
                <div class="card-body">
                    <h6 class="card-title text-muted mb-3">Customer Information</h6>
                    <h5><?php echo e($project->customer->name); ?></h5>
                    <p class="mb-1"><i class="fas fa-envelope me-2 text-muted"></i><?php echo e($project->customer->email); ?></p>
                    <p><i class="fas fa-phone me-2 text-muted"></i><?php echo e($project->customer->phone); ?></p>
                    <a href="<?php echo e(route('customers.show', $project->customer)); ?>"
                        class="btn btn-sm btn-outline-info w-100">View Client Profile</a>
                </div>
            </div>

            <div class="card bg-dark border-secondary">
                <div class="card-body text-center">
                    <h6 class="card-title text-muted mb-3">Project Programmer</h6>
                    <div class="avatar-placeholder mb-2 bg-secondary rounded-circle mx-auto d-flex align-items-center justify-content-center"
                        style="width: 60px; height: 60px;">
                        <i class="fas fa-user-code fa-2x"></i>
                    </div>
                    <h5><?php echo e($project->programmer->name); ?></h5>
                    <p class="text-muted small mb-3">Developer / User</p>
                    <a href="<?php echo e(route('accounting.programmers.statement', $project->programmer)); ?>"
                        class="btn btn-sm btn-outline-success w-100 mb-2">View Full Statement</a>
                    <button class="btn btn-sm btn-outline-light w-100">Send WhatsApp Notification</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Update Progress Modal -->
    <div class="modal fade" id="updateProgressModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content bg-dark border-secondary text-white">
                <form action="<?php echo e(route('accounting.projects.progress', $project)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-header border-secondary">
                        <h5 class="modal-title text-start">Update Project Progress</h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body text-start">
                        <div class="mb-3 text-start">
                            <label class="form-label">Completion Percentage (%)</label>
                            <input type="range" name="progress_percent" class="form-range" min="0" max="100"
                                value="<?php echo e($project->progress_percent); ?>">
                            <div class="text-center fw-bold text-success h4" id="rangeValue">
                                <?php echo e($project->progress_percent); ?>%
                            </div>
                        </div>
                        <div class="mb-3 text-start">
                            <label class="form-label">Update Status</label>
                            <select name="status" class="form-select bg-black text-white border-secondary">
                                <option value="pending" <?php echo e($project->status == 'pending' ? 'selected' : ''); ?>>Pending</option>
                                <option value="in_progress" <?php echo e($project->status == 'in_progress' ? 'selected' : ''); ?>>In
                                    Progress</option>
                                <option value="completed" <?php echo e($project->status == 'completed' ? 'selected' : ''); ?>>Completed
                                </option>
                                <option value="on_hold" <?php echo e($project->status == 'on_hold' ? 'selected' : ''); ?>>On Hold</option>
                                <option value="cancelled" <?php echo e($project->status == 'cancelled' ? 'selected' : ''); ?>>Cancelled
                                </option>
                            </select>
                        </div>
                        <div class="mb-3 text-start">
                            <label class="form-label">Developer Notes / Achievement</label>
                            <textarea name="notes" rows="3"
                                class="form-control bg-black text-white border-secondary"><?php echo e($project->notes); ?></textarea>
                        </div>
                    </div>
                    <div class="modal-footer border-secondary">
                        <button type="button" class="btn btn-outline-light" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-success">Save Update</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Record Payment Modal -->
    <div class="modal fade" id="recordPaymentModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content bg-dark border-secondary text-white">
                <form action="<?php echo e(route('accounting.projects.payment', $project)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-header border-secondary">
                        <h5 class="modal-title text-start">Record Payout to Developer</h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body text-start">
                        <div class="mb-3">
                            <label class="form-label">Payment Amount</label>
                            <div class="input-group">
                                <input type="number" name="amount" step="0.01"
                                    class="form-control bg-black text-white border-secondary" required
                                    value="<?php echo e($project->remaining_programmer_balance); ?>">
                                <span class="input-group-text bg-secondary border-secondary text-white">EGP</span>
                            </div>
                            <small class="text-muted">Max. Remaining Balance:
                                <?php echo e(number_format($project->remaining_programmer_balance, 2)); ?> EGP</small>
                        </div>
                        <div class="mb-3">
                            <label class="form-label"><?php echo e(__('Deduct From Treasury')); ?></label>
                            <select name="treasury_id" class="form-select bg-black text-white border-secondary" required>
                                <?php $__currentLoopData = $treasuries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $treasury): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($treasury->id); ?>"><?php echo e($treasury->name); ?>

                                        (<?php echo e(number_format($treasury->balance, 2)); ?>)</option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Payment Date</label>
                            <input type="date" name="date" class="form-control bg-black text-white border-secondary"
                                value="<?php echo e(date('Y-m-d')); ?>" required>
                        </div>
                        <div class="mb-3 text-start">
                            <label class="form-label">Payment Method / Notes</label>
                            <textarea name="notes" rows="2" class="form-control bg-black text-white border-secondary"
                                placeholder="e.g. Cash payment, Bank transfer..."></textarea>
                        </div>
                    </div>
                    <div class="modal-footer border-secondary">
                        <button type="button" class="btn btn-outline-light" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Confirm Payout</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
        <script>
            document.querySelector('input[name="progress_percent"]').addEventListener('input', function () {
                document.getElementById('rangeValue').innerText = this.value + '%';
            });
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\code\resources\views/accounting/projects/show.blade.php ENDPATH**/ ?>