

<?php $__env->startSection('content'); ?>
    <div class="row mb-4">
        <div class="col-12 d-flex justify-content-between align-items-center">
            <div>
                <h2 class="fw-light">تذاكر الدعم الفني</h2>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">لوحة التحكم</a></li>
                        <li class="breadcrumb-item active">التذاكر</li>
                    </ol>
                </nav>
            </div>
            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createTicketModal">
                <i class="fas fa-plus me-1"></i> فتح تذكرة جديدة
            </button>
        </div>
    </div>

    <!-- Create Ticket Modal -->
    <div class="modal fade" id="createTicketModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content bg-dark text-white border-secondary">
                <div class="modal-header border-secondary">
                    <h5 class="modal-title">فتح تذكرة جديدة</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                        aria-label="Close"></button>
                </div>
                <form action="<?php echo e(route('accounting.tickets.store_generic')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">العميل</label>
                            <select name="customer_id" class="form-select bg-black text-white border-secondary" required>
                                <option value="">-- اختر العميل --</option>
                                <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($customer->id); ?>"><?php echo e($customer->name); ?> (<?php echo e($customer->company); ?>)
                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <div class="form-text text-muted">يظهر فقط العملاء المربوطين بـ WHMCS.</div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">عنوان التذكرة</label>
                            <input type="text" name="subject" class="form-control bg-black text-white border-secondary"
                                required>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">القسم</label>
                                <select name="deptid" class="form-select bg-black text-white border-secondary">
                                    <option value="1">Support</option>
                                    <option value="2">Sales</option>
                                    <option value="3">Billing</option>
                                </select>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">الأولوية</label>
                                <select name="priority" class="form-select bg-black text-white border-secondary">
                                    <option value="Low">منخفض</option>
                                    <option value="Medium" selected>متوسط</option>
                                    <option value="High">عالي</option>
                                </select>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">نص الرسالة</label>
                            <textarea name="message" class="form-control bg-black text-white border-secondary" rows="4"
                                required></textarea>
                        </div>
                    </div>
                    <div class="modal-footer border-secondary">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إغلاق</button>
                        <button type="submit" class="btn btn-primary">فتح التذكرة</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    </div>

    <div class="card glass-card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover table-dark align-middle">
                    <thead class="bg-black">
                        <tr>
                            <th>#</th>
                            <th>العميل</th>
                            <th>الموضوع</th>
                            <th>القسم</th>
                            <th>الحالة</th>
                            <th>الأولوية</th>
                            <th>آخر رد</th>
                            <th class="text-end">الإجراء</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $tickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>#<?php echo e($ticket->whmcs_id); ?></td>
                                <td>
                                    <a href="<?php echo e(route('customers.show', $ticket->customer)); ?>"
                                        class="text-info text-decoration-none">
                                        <?php echo e($ticket->customer->name); ?>

                                    </a>
                                </td>
                                <td><?php echo e($ticket->subject); ?></td>
                                <td><?php echo e($ticket->department); ?></td>
                                <td>
                                    <?php
                                        $status_color = match (strtolower($ticket->status)) {
                                            'open' => 'danger',
                                            'answered' => 'success',
                                            'customer-reply' => 'warning',
                                            'closed' => 'secondary',
                                            default => 'info'
                                        };
                                    ?>
                                    <span class="badge bg-<?php echo e($status_color); ?>"><?php echo e($ticket->status); ?></span>
                                </td>
                                <td>
                                    <?php
                                        $priority_color = match (strtolower($ticket->priority)) {
                                            'high', 'critical' => 'danger',
                                            'medium' => 'warning',
                                            'low' => 'info',
                                            default => 'secondary'
                                        };
                                    ?>
                                    <span class="text-<?php echo e($priority_color); ?>"><?php echo e($ticket->priority); ?></span>
                                </td>
                                <td><?php echo e($ticket->last_reply); ?></td>
                                <td class="text-end">
                                    <a href="<?php echo e(route('accounting.tickets.show', $ticket)); ?>"
                                        class="btn btn-sm btn-outline-light" title="عرض">
                                        <i class="fas fa-eye"></i> عرض
                                    </a>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete tickets')): ?>
                                        <form action="<?php echo e(route('accounting.tickets.destroy', $ticket)); ?>" method="POST"
                                            class="d-inline" onsubmit="return confirm('هل أنت متأكد من حذف هذه التذكرة؟')">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-sm btn-outline-danger" title="حذف">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    <?php endif; ?>

                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="8" class="text-center py-5 text-muted">لا توجد تذاكر حالياً.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <div class="mt-4">
                <?php echo e($tickets->links()); ?>

            </div>
        </div>
    </div>

    <style>
        .glass-card {
            background: rgba(255, 255, 255, 0.05);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        /* Mobile card view for tickets */
        @media (max-width: 768px) {
            .table-responsive .table thead {
                display: none;
            }

            .table-responsive .table,
            .table-responsive .table tbody,
            .table-responsive .table tr {
                display: block;
                width: 100%;
            }

            .table-responsive .table tr {
                margin-bottom: 1rem;
                border: 1px solid rgba(255, 255, 255, 0.1);
                border-radius: 8px;
                padding: 1rem;
                background: rgba(0, 0, 0, 0.2);
            }

            .table-responsive .table td {
                display: flex;
                justify-content: space-between;
                padding: 0.5rem 0;
                border: none !important;
                text-align: left;
            }

            .table-responsive .table td::before {
                content: attr(data-label);
                font-weight: bold;
                color: #aaa;
                margin-left: 1rem;
            }

            .table-responsive .table td.text-end {
                justify-content: center;
            }
        }
    </style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\code\resources\views/accounting/tickets/index.blade.php ENDPATH**/ ?>