

<?php $__env->startSection('content'); ?>
    <div class="row mb-4">
        <div class="col-12">
            <h2 class="fw-light">Register New Supplier</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
                    <li class="breadcrumb-item"><a
                            href="<?php echo e(route('accounting.suppliers.index')); ?>"><?php echo e(__('Suppliers')); ?></a></li>
                    <li class="breadcrumb-item active"><?php echo e(__('Create')); ?></li>
                </ol>
            </nav>
        </div>
    </div>

    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-body">
                    <form action="<?php echo e(route('accounting.suppliers.store')); ?>" method="POST">
                        <?php echo csrf_field(); ?>

                        <div class="mb-3">
                            <label class="form-label">Company / Name <span class="text-danger">*</span></label>
                            <input type="text" name="name" class="form-control"
                                placeholder="e.g. Vodafone, Amazon AWS, Office Depot" required>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Phone</label>
                                <input type="text" name="phone" class="form-control">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Email</label>
                                <input type="email" name="email" class="form-control">
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Tax ID (Registration No)</label>
                            <input type="text" name="tax_id" class="form-control" placeholder="For tax filing purposes">
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label"><?php echo e(__('Currency')); ?></label>
                                <select name="currency_id" class="form-select">
                                    <option value=""><?php echo e(__('Default (System Base)')); ?></option>
                                    <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($currency->id); ?>"><?php echo e($currency->code); ?> - <?php echo e($currency->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label"><?php echo e(__('Opening Balance')); ?></label>
                                <div class="input-group">
                                    <input type="number" step="0.01" name="opening_balance" class="form-control" value="0">
                                </div>
                                <small class="text-muted"><?php echo e(__('Positive value means you owe the supplier.')); ?></small>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Address</label>
                            <textarea name="address" class="form-control" rows="2"></textarea>
                        </div>

                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-primary">Register Supplier</button>
                            <a href="<?php echo e(route('accounting.suppliers.index')); ?>" class="btn btn-outline-secondary">Cancel</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\code\resources\views/accounting/suppliers/create.blade.php ENDPATH**/ ?>