

<?php $__env->startSection('content'); ?>
    <div class="row mb-4">
        <div class="col-12 col-md-6">
            <h2 class="fw-light"><?php echo e(__('Journal Entries')); ?></h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
                    <li class="breadcrumb-item active"><?php echo e(__('Journal Entries')); ?></li>
                </ol>
            </nav>
        </div>
        <div class="col-12 col-md-6 text-md-end">
            <a href="<?php echo e(route('accounting.journals.create')); ?>" class="btn btn-primary">
                <i class="fas fa-plus-circle me-2"></i><?php echo e(__('New Journal Entry')); ?>

            </a>
        </div>
    </div>

    <div class="card">
        <div class="card-body p-0">
            <div class="table-responsive table-responsive-stack">
                <table class="table table-hover align-middle mb-0">
                    <thead class="table-dark">
                        <tr>
                            <th><?php echo e(__('Date')); ?></th>
                            <th><?php echo e(__('Reference')); ?></th>
                            <th><?php echo e(__('Description')); ?></th>
                            <th class="text-end"><?php echo e(__('Amount')); ?></th>
                            <th class="text-center"><?php echo e(__('Status')); ?></th>
                            <th><?php echo e(__('Posted By')); ?></th>
                            <th><?php echo e(__('Actions')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $entries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $entry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td data-label="<?php echo e(__('Date')); ?>"><?php echo e($entry->date->format('Y-m-d')); ?></td>
                                <td data-label="<?php echo e(__('Reference')); ?>"><?php echo e($entry->reference ?? '-'); ?></td>
                                <td data-label="<?php echo e(__('Description')); ?>"><?php echo e(Str::limit($entry->description, 50)); ?></td>
                                <td data-label="<?php echo e(__('Amount')); ?>" class="text-end fw-bold">
                                    <?php echo e(number_format($entry->lines->sum('debit'), 2)); ?></td>
                                <td data-label="<?php echo e(__('Status')); ?>" class="text-center">
                                    <?php if($entry->locked): ?>
                                        <span class="badge bg-secondary"><i class="fas fa-lock"></i> <?php echo e(__('Locked')); ?></span>
                                    <?php else: ?>
                                        <span class="badge bg-success"><?php echo e(__('Posted')); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td data-label="<?php echo e(__('Posted By')); ?>"><?php echo e($entry->user->name ?? 'System'); ?></td>
                                <td data-label="<?php echo e(__('Actions')); ?>">
                                    <a href="<?php echo e(route('accounting.journals.show', $entry)); ?>"
                                        class="btn btn-sm btn-outline-info">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="7" class="text-center py-5">
                                    <i class="fas fa-book fa-3x text-muted mb-3"></i>
                                    <h3><?php echo e(__('No journal entries found')); ?></h3>
                                    <p class="text-muted"><?php echo e(__('Create a manual entry to adjust accounts.')); ?></p>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php if($entries->hasPages()): ?>
            <div class="card-footer">
                <?php echo e($entries->links()); ?>

            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\code\resources\views/accounting/journals/index.blade.php ENDPATH**/ ?>