

<?php $__env->startSection('content'); ?>
    <div class="row mb-4">
        <div class="col-12">
            <h2 class="fw-light"><?php echo e(__('Record Purchase Bill')); ?></h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(route('accounting.bills.index')); ?>"><?php echo e(__('Bills')); ?></a></li>
                    <li class="breadcrumb-item active"><?php echo e(__('Create')); ?></li>
                </ol>
            </nav>
        </div>
    </div>

    <div class="row justify-content-center">
        <div class="col-md-10">
            <form action="<?php echo e(route('accounting.bills.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="card mb-4">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label"><?php echo e(__('Supplier')); ?> <span class="text-danger">*</span></label>
                                <select name="supplier_id" class="form-select" required>
                                    <option value=""><?php echo e(__('Select Supplier')); ?></option>
                                    <?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($supplier->id); ?>"><?php echo e($supplier->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <div class="form-text"><a
                                        href="<?php echo e(route('accounting.suppliers.create')); ?>"><?php echo e(__('Add new supplier')); ?></a>
                                </div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label"><?php echo e(__('Bill Number (Reference)')); ?></label>
                                <input type="text" name="code" class="form-control" value="<?php echo e($code); ?>" required>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label"><?php echo e(__('Currency')); ?></label>
                                <select name="currency_id" class="form-select">
                                    <option value=""><?php echo e(__('Default (System Base)')); ?></option>
                                    <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($currency->id); ?>"><?php echo e($currency->code); ?> - <?php echo e($currency->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label"><?php echo e(__('Exchange Rate')); ?></label>
                                <input type="number" step="0.000001" name="exchange_rate" class="form-control"
                                    value="1.000000">
                                <small class="text-muted"><?php echo e(__('Rate relative to system base currency')); ?></small>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label"><?php echo e(__('Date')); ?> <span class="text-danger">*</span></label>
                                <input type="date" name="date" class="form-control" value="<?php echo e(date('Y-m-d')); ?>" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label"><?php echo e(__('Due Date')); ?></label>
                                <input type="date" name="due_date" class="form-control">
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card mb-4">
                    <div class="card-header bg-dark border-secondary">
                        <h5 class="mb-0"><?php echo e(__('Bill Details')); ?></h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label class="form-label"><?php echo e(__('Subtotal (Before Tax)')); ?> <span
                                        class="text-danger">*</span></label>
                                <input type="number" step="0.01" name="subtotal" class="form-control" required>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label"><?php echo e(__('Tax Amount (VAT)')); ?></label>
                                <input type="number" step="0.01" name="tax_amount" class="form-control" value="0">
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label"><?php echo e(__('Notes')); ?></label>
                                <input type="text" name="notes" class="form-control"
                                    placeholder="<?php echo e(__('What was this for?')); ?>">
                            </div>
                        </div>
                    </div>
                    <div class="card-footer border-secondary text-end">
                        <button type="submit" class="btn btn-primary btn-lg"><?php echo e(__('Save Bill')); ?></button>
                        <a href="<?php echo e(route('accounting.bills.index')); ?>"
                            class="btn btn-outline-secondary btn-lg"><?php echo e(__('Cancel')); ?></a>
                    </div>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\code\resources\views/accounting/bills/create.blade.php ENDPATH**/ ?>