

<?php $__env->startSection('content'); ?>
    <div class="row mb-4">
        <div class="col-12">
            <h2 class="fw-light"><?php echo e(__('Edit Supplier')); ?></h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
                    <li class="breadcrumb-item"><a
                            href="<?php echo e(route('accounting.suppliers.index')); ?>"><?php echo e(__('Suppliers')); ?></a></li>
                    <li class="breadcrumb-item active"><?php echo e($supplier->name); ?></li>
                </ol>
            </nav>
        </div>
    </div>

    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-body">
                    <form action="<?php echo e(route('accounting.suppliers.update', $supplier)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>

                        <div class="mb-3">
                            <label class="form-label"><?php echo e(__('Company / Name')); ?> <span class="text-danger">*</span></label>
                            <input type="text" name="name" class="form-control" value="<?php echo e($supplier->name); ?>" required>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label"><?php echo e(__('Phone')); ?></label>
                                <input type="text" name="phone" class="form-control" value="<?php echo e($supplier->phone); ?>">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label"><?php echo e(__('Email')); ?></label>
                                <input type="email" name="email" class="form-control" value="<?php echo e($supplier->email); ?>">
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label"><?php echo e(__('Tax ID (Registration No)')); ?></label>
                            <input type="text" name="tax_id" class="form-control" value="<?php echo e($supplier->tax_id); ?>">
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label"><?php echo e(__('Currency')); ?></label>
                                <select name="currency_id" class="form-select">
                                    <option value=""><?php echo e(__('Default (System Base)')); ?></option>
                                    <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($currency->id); ?>" <?php echo e($supplier->currency_id == $currency->id ? 'selected' : ''); ?>>
                                            <?php echo e($currency->code); ?> - <?php echo e($currency->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label"><?php echo e(__('Opening Balance')); ?></label>
                                <input type="number" step="0.01" name="opening_balance" class="form-control"
                                    value="<?php echo e($supplier->opening_balance); ?>">
                                <small class="text-muted"><?php echo e(__('Positive value means you owe the supplier.')); ?></small>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label"><?php echo e(__('Address')); ?></label>
                            <textarea name="address" class="form-control" rows="2"><?php echo e($supplier->address); ?></textarea>
                        </div>

                        <div class="mb-3 form-check">
                            <input type="checkbox" name="is_active" class="form-check-input" id="isActive" <?php echo e($supplier->is_active ? 'checked' : ''); ?> value="1">
                            <label class="form-check-label" for="isActive"><?php echo e(__('Active Supplier')); ?></label>
                        </div>

                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-primary"><?php echo e(__('Save Changes')); ?></button>
                            <a href="<?php echo e(route('accounting.suppliers.index')); ?>"
                                class="btn btn-outline-secondary"><?php echo e(__('Cancel')); ?></a>
                        </div>
                    </form>

                    <hr class="my-4">

                    <div class="text-center">
                        <form action="<?php echo e(route('accounting.suppliers.destroy', $supplier)); ?>" method="POST"
                            onsubmit="return confirm('<?php echo e(__('Are you sure? This will deactivate the supplier.')); ?>')">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button class="btn btn-danger btn-sm"><?php echo e(__('Deactivate Supplier')); ?></button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\code\resources\views/accounting/suppliers/edit.blade.php ENDPATH**/ ?>