

<?php $__env->startSection('content'); ?>
    <div class="row mb-4">
        <div class="col-12">
            <h2 class="fw-light">Financial Statement: <?php echo e($user->name); ?></h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(route('accounting.projects.index')); ?>"><?php echo e(__('Projects')); ?></a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('Statement')); ?></li>
                </ol>
            </nav>
        </div>
    </div>

    <div class="row mb-4">
        <div class="col-md-4">
            <div class="card bg-primary text-white text-center">
                <div class="card-body">
                    <h6 class="opacity-75">Total Earned Commissions</h6>
                    <h3><?php echo e(number_format($user->total_earned, 2)); ?> EGP</h3>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card bg-success text-white text-center">
                <div class="card-body">
                    <h6 class="opacity-75">Total Received Amount</h6>
                    <h3><?php echo e(number_format($user->total_paid, 2)); ?> EGP</h3>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card bg-danger text-white text-center">
                <div class="card-body">
                    <h6 class="opacity-75">Remaining Account Balance</h6>
                    <h3><?php echo e(number_format($user->balance, 2)); ?> EGP</h3>
                </div>
            </div>
        </div>
    </div>

    <div class="card bg-dark border-secondary">
        <div class="card-header bg-black py-3">
            <h5 class="mb-0 text-white">Project List & Statuses</h5>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover table-dark mb-0">
                    <thead class="bg-black">
                        <tr>
                            <th>Project</th>
                            <th>Customer</th>
                            <th>Status</th>
                            <th>Commission</th>
                            <th>Paid From Project</th>
                            <th>Project Balance</th>
                            <th class="text-end">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $user->projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($project->name); ?></td>
                                <td><?php echo e($project->customer->name); ?></td>
                                <td>
                                    <span class="badge bg-<?php echo e($project->status == 'completed' ? 'success' : 'info'); ?>">
                                        <?php echo e(ucfirst($project->status)); ?> (<?php echo e($project->progress_percent); ?>%)
                                    </span>
                                </td>
                                <td><?php echo e(number_format($project->commission_amount, 2)); ?> EGP</td>
                                <td class="text-success"><?php echo e(number_format($project->paid_to_programmer, 2)); ?> EGP</td>
                                <td class="fw-bold text-danger"><?php echo e(number_format($project->remaining_programmer_balance, 2)); ?>

                                    EGP</td>
                                <td class="text-end">
                                    <a href="<?php echo e(route('accounting.projects.show', $project)); ?>"
                                        class="btn btn-sm btn-outline-light">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\code\resources\views/accounting/projects/programmer_statement.blade.php ENDPATH**/ ?>