<!-- Page Header -->
<div class="d-flex justify-content-between align-items-center flex-wrap gap-3 mb-4">
    <div>
        <h3 class="mb-0"><?php echo e(__('Treasuries & Banks')); ?></h3>
        <p class="text-muted"><?php echo e(__('Manage cash safes, bank accounts, and digital wallets')); ?></p>
    </div>
    <div class="d-flex gap-2">
        <button type="button" class="btn btn-outline-light" data-bs-toggle="modal" data-bs-target="#transferModal">
            <i class="fas fa-exchange-alt me-2"></i><?php echo e(__('Transfer')); ?>

        </button>
        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createTreasuryModal">
            <i class="fas fa-plus-circle me-2"></i><?php echo e(__('New Treasury')); ?>

        </button>
    </div>
</div>

<!-- Stats Row -->
<div class="row g-4 mb-4">
    <div class="col-6 col-lg-3">
        <div class="stat-card cyan">
            <div class="stat-icon"><i class="fas fa-vault"></i></div>
            <div class="stat-value"><?php echo e($treasuries->count()); ?></div>
            <div class="stat-label"><?php echo e(__('Total Treasuries')); ?></div>
        </div>
    </div>
    <div class="col-6 col-lg-3">
        <div class="stat-card green">
            <div class="stat-icon"><i class="fas fa-coins"></i></div>
            <div class="stat-value"><?php echo e(number_format($treasuries->sum('balance'), 0)); ?></div>
            <div class="stat-label"><?php echo e(__('Total Balance (EGP)')); ?></div>
        </div>
    </div>
    <div class="col-6 col-lg-3">
        <div class="stat-card purple">
            <div class="stat-icon"><i class="fas fa-cash-register"></i></div>
            <div class="stat-value"><?php echo e($treasuries->where('type', 'cash')->count()); ?></div>
            <div class="stat-label"><?php echo e(__('Cash Safes')); ?></div>
        </div>
    </div>
    <div class="col-6 col-lg-3">
        <div class="stat-card yellow">
            <div class="stat-icon"><i class="fas fa-university"></i></div>
            <div class="stat-value"><?php echo e($treasuries->where('type', 'bank')->count()); ?></div>
            <div class="stat-label"><?php echo e(__('Bank Accounts')); ?></div>
        </div>
    </div>
</div>

<div class="row">
    <?php $__empty_1 = true; $__currentLoopData = $treasuries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $treasury): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="col-md-4 mb-4">
            <div
                class="card h-100 border-start border-4 <?php echo e($treasury->type == 'cash' ? 'border-success' : ($treasury->type == 'bank' ? 'border-primary' : 'border-warning')); ?>">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start mb-3">
                        <div>
                            <h5 class="card-title fw-bold"><?php echo e($treasury->name); ?></h5>
                            <span class="badge bg-secondary text-uppercase"><?php echo e(__($treasury->type)); ?></span>
                        </div>
                        <div class="dropdown">
                            <button class="btn btn-sm btn-link text-muted" type="button" data-bs-toggle="dropdown">
                                <i class="fas fa-ellipsis-v"></i>
                            </button>
                            <ul class="dropdown-menu dropdown-menu-dark">
                                <li><a class="dropdown-item"
                                        href="<?php echo e(route('accounting.treasuries.show', $treasury)); ?>"><?php echo e(__('View Transactions')); ?></a>
                                </li>
                                <li><button class="dropdown-item" data-bs-toggle="modal"
                                        data-bs-target="#editTreasury<?php echo e($treasury->id); ?>"><?php echo e(__('Edit')); ?></button></li>
                            </ul>
                        </div>
                    </div>

                    <h3 class="mb-3"><?php echo e(number_format($treasury->balance, 2)); ?> <small
                            class="text-muted fs-6"><?php echo e($treasury->currency ?? 'EGP'); ?></small></h3>

                    <div class="text-muted small">
                        <i class="fas fa-history me-1"></i> <?php echo e($treasury->transactions_count); ?> <?php echo e(__('Transactions')); ?>

                    </div>

                    <div class="mt-3 d-grid">
                        <a href="<?php echo e(route('accounting.treasuries.show', $treasury)); ?>"
                            class="btn btn-outline-light btn-sm"><?php echo e(__('Manage')); ?></a>
                    </div>
                </div>
            </div>

            <!-- Edit Modal -->
            <div class="modal fade" id="editTreasury<?php echo e($treasury->id); ?>" tabindex="-1">
                <div class="modal-dialog">
                    <form action="<?php echo e(route('accounting.treasuries.update', $treasury)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        <div class="modal-content bg-dark">
                            <div class="modal-header border-secondary">
                                <h5 class="modal-title"><?php echo e(__('Edit Treasury')); ?></h5>
                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                            </div>
                            <div class="modal-body">
                                <div class="mb-3">
                                    <label class="form-label"><?php echo e(__('Name')); ?></label>
                                    <input type="text" name="name" class="form-control" value="<?php echo e($treasury->name); ?>"
                                        required>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label"><?php echo e(__('Type')); ?></label>
                                    <select name="type" class="form-select" required>
                                        <option value="cash" <?php echo e($treasury->type == 'cash' ? 'selected' : ''); ?>>
                                            <?php echo e(__('Cash Safe (خزنة نقدية)')); ?>

                                        </option>
                                        <option value="bank" <?php echo e($treasury->type == 'bank' ? 'selected' : ''); ?>>
                                            <?php echo e(__('Bank Account (حساب بنكي)')); ?>

                                        </option>
                                        <option value="wallet" <?php echo e($treasury->type == 'wallet' ? 'selected' : ''); ?>>
                                            <?php echo e(__('Digital Wallet (محفظة رقمية)')); ?>

                                        </option>
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label"><?php echo e(__('Currency')); ?></label>
                                    <select name="currency_id" class="form-select">
                                        <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($currency->id); ?>" <?php echo e($treasury->currency_id == $currency->id ? 'selected' : ''); ?>>
                                                <?php echo e($currency->code); ?> - <?php echo e($currency->name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="modal-footer border-secondary">
                                <button type="button" class="btn btn-secondary"
                                    data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                                <button type="submit" class="btn btn-primary"><?php echo e(__('Save Changes')); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <div class="col-12 text-center py-5">
            <i class="fas fa-vault fa-3x text-muted mb-3"></i>
            <h3><?php echo e(__('No treasuries found')); ?></h3>
            <p class="text-muted"><?php echo e(__('Create a safe or bank account to start tracking finances.')); ?></p>
        </div>
    <?php endif; ?>
</div>

<!-- Create Modal -->
<div class="modal fade" id="createTreasuryModal" tabindex="-1">
    <div class="modal-dialog">
        <form action="<?php echo e(route('accounting.treasuries.store')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="modal-content bg-dark">
                <div class="modal-header border-secondary">
                    <h5 class="modal-title"><?php echo e(__('Create New Treasury')); ?></h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label"><?php echo e(__('Name')); ?> <span class="text-danger">*</span></label>
                        <input type="text" name="name" class="form-control"
                            placeholder="<?php echo e(__('e.g. Main Safe, CIB Bank')); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label"><?php echo e(__('Type')); ?> <span class="text-danger">*</span></label>
                        <select name="type" class="form-select" required>
                            <option value="cash"><?php echo e(__('Cash Safe (خزنة نقدية)')); ?></option>
                            <option value="bank"><?php echo e(__('Bank Account (حساب بنكي)')); ?></option>
                            <option value="wallet"><?php echo e(__('Digital Wallet (محفظة رقمية)')); ?></option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label"><?php echo e(__('Currency')); ?></label>
                        <select name="currency_id" class="form-select">
                            <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($currency->id); ?>" <?php echo e($currency->is_base ? 'selected' : ''); ?>>
                                    <?php echo e($currency->code); ?> - <?php echo e($currency->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label"><?php echo e(__('Opening Balance (Raseed Eftitahy)')); ?></label>
                        <input type="number" step="0.01" name="balance" class="form-control" value="0">
                        <div class="form-text text-muted"><?php echo e(__('Initial amount in this treasury.')); ?></div>
                    </div>
                </div>
                <div class="modal-footer border-secondary">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                    <button type="submit" class="btn btn-primary"><?php echo e(__('Create Treasury')); ?></button>
                </div>
            </div>
        </form>
    </div>
</div>
</div>

<!-- Transfer Modal -->
<div class="modal fade" id="transferModal" tabindex="-1">
    <div class="modal-dialog">
        <form action="<?php echo e(route('accounting.treasuries.transfer')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="modal-content bg-dark">
                <div class="modal-header border-secondary">
                    <h5 class="modal-title"><?php echo e(__('Transfer Funds')); ?></h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label"><?php echo e(__('From (Source)')); ?> <span class="text-danger">*</span></label>
                        <select name="from_treasury_id" class="form-select" required>
                            <?php $__currentLoopData = $treasuries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($t->id); ?>"><?php echo e($t->name); ?> (<?php echo e(number_format($t->balance, 2)); ?>)</option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label"><?php echo e(__('To (Destination)')); ?> <span
                                class="text-danger">*</span></label>
                        <select name="to_treasury_id" class="form-select" required>
                            <?php $__currentLoopData = $treasuries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($t->id); ?>"><?php echo e($t->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label"><?php echo e(__('Amount')); ?> <span class="text-danger">*</span></label>
                        <input type="number" step="0.01" name="amount" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label"><?php echo e(__('Date')); ?> <span class="text-danger">*</span></label>
                        <input type="date" name="date" class="form-control" value="<?php echo e(date('Y-m-d')); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label"><?php echo e(__('Description')); ?></label>
                        <input type="text" name="description" class="form-control"
                            placeholder="<?php echo e(__('Reason for transfer')); ?>">
                    </div>
                </div>
                <div class="modal-footer border-secondary">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                    <button type="submit" class="btn btn-warning"><?php echo e(__('Execute Transfer')); ?></button>
                </div>
            </div>
        </form>
    </div>
</div><?php /**PATH C:\xampp\htdocs\code\resources\views/accounting/treasuries/_list.blade.php ENDPATH**/ ?>