

<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="page-header d-flex justify-content-between align-items-center">
            <div>
                <h1 class="page-title"><?php echo e(__('General Expenses')); ?></h1>
                <p class="page-subtitle"><?php echo e(__('Manage your operational daily expenses')); ?></p>
            </div>
            <a href="<?php echo e(route('accounting.expenses.create')); ?>" class="btn btn-primary premium-shadow">
                <i class="fas fa-plus me-2"></i> <?php echo e(__('Record New Expense')); ?>

            </a>
        </div>

        <!-- Stats Cards -->
        <div class="row g-3 mb-4">
            <div class="col-md-6 col-lg-3">
                <div class="stat-card orange">
                    <div class="stat-icon">
                        <i class="fas fa-money-bill-wave"></i>
                    </div>
                    <div class="stat-value"><?php echo e(number_format($stats['total_amount'], 2)); ?></div>
                    <div class="stat-label"><?php echo e(__('Total Expenses')); ?></div>
                </div>
            </div>
            <div class="col-md-6 col-lg-3">
                <div class="stat-card purple">
                    <div class="stat-icon">
                        <i class="fas fa-list-ol"></i>
                    </div>
                    <div class="stat-value"><?php echo e($stats['count']); ?></div>
                    <div class="stat-label"><?php echo e(__('Transaction Count')); ?></div>
                </div>
            </div>
        </div>

        <!-- Filters -->
        <div class="card glass-card mb-4">
            <div class="card-body">
                <form action="<?php echo e(route('accounting.expenses.index')); ?>" method="GET" class="row g-3">
                    <div class="col-md-3">
                        <label class="form-label"><?php echo e(__('Category')); ?></label>
                        <select name="category_id" class="form-select">
                            <option value=""><?php echo e(__('All Categories')); ?></option>
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($category->id); ?>" <?php echo e(request('category_id') == $category->id ? 'selected' : ''); ?>>
                                    <?php echo e($category->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label"><?php echo e(__('Treasury')); ?></label>
                        <select name="treasury_id" class="form-select">
                            <option value=""><?php echo e(__('All Treasuries')); ?></option>
                            <?php $__currentLoopData = $treasuries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $treasury): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($treasury->id); ?>" <?php echo e(request('treasury_id') == $treasury->id ? 'selected' : ''); ?>>
                                    <?php echo e($treasury->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label"><?php echo e(__('From')); ?></label>
                        <input type="date" name="date_from" class="form-control" value="<?php echo e(request('date_from')); ?>">
                    </div>
                    <div class="col-md-2">
                        <label class="form-label"><?php echo e(__('To')); ?></label>
                        <input type="date" name="date_to" class="form-control" value="<?php echo e(request('date_to')); ?>">
                    </div>
                    <div class="col-md-2 d-flex align-items-end">
                        <div class="btn-group w-100">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-filter"></i>
                            </button>
                            <a href="<?php echo e(route('accounting.expenses.index')); ?>" class="btn btn-outline-secondary">
                                <i class="fas fa-undo"></i>
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Expenses Table -->
        <div class="card glass-card">
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead>
                            <tr>
                                <th><?php echo e(__('Date')); ?></th>
                                <th><?php echo e(__('Category')); ?></th>
                                <th><?php echo e(__('Reference')); ?></th>
                                <th><?php echo e(__('Treasury')); ?></th>
                                <th><?php echo e(__('Description')); ?></th>
                                <th><?php echo e(__('Amount')); ?></th>
                                <th class="text-end"><?php echo e(__('Actions')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expense): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e(\Carbon\Carbon::parse($expense->date)->format('Y-m-d')); ?></td>
                                    <td>
                                        <span class="badge bg-soft-info text-info">
                                            <?php echo e($expense->category->name ?? __('Uncategorized')); ?>

                                        </span>
                                    </td>
                                    <td><code class="text-muted"><?php echo e($expense->ref_no ?? '---'); ?></code></td>
                                    <td><?php echo e($expense->treasury->name ?? '---'); ?></td>
                                    <td><?php echo e(Str::limit($expense->description, 50)); ?></td>
                                    <td class="fw-bold text-danger">
                                        <?php echo e(number_format($expense->amount, 2)); ?> <?php echo e($expense->treasury->currency->code ?? ''); ?>

                                    </td>
                                    <td class="text-end">
                                        <form action="<?php echo e(route('accounting.expenses.destroy', $expense)); ?>" method="POST"
                                            class="d-inline"
                                            onsubmit="return confirm('<?php echo e(__('Are you sure you want to delete this expense? This will revert the treasury balance.')); ?>')">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-sm btn-outline-danger">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="7" class="text-center py-4 text-muted">
                                        <i class="fas fa-receipt fa-3x mb-3 d-block"></i>
                                        <?php echo e(__('No expenses found for the selected criteria.')); ?>

                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <?php if($expenses->hasPages()): ?>
                <div class="card-footer glass-card-footer">
                    <?php echo e($expenses->links()); ?>

                </div>
            <?php endif; ?>
        </div>
    </div>

    <style>
        .bg-soft-info {
            background-color: rgba(0, 212, 255, 0.1);
            color: #00d4ff;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\code\resources\views/accounting/expenses/index.blade.php ENDPATH**/ ?>