

<?php $__env->startSection('content'); ?>
    <div class="row mb-4">
        <div class="col-12 col-md-4">
            <h2 class="fw-light mb-0"><?php echo e(__('Programmers Management')); ?></h2>
            <p class="text-muted small"><?php echo e(__('Manage programmers, track их commissions, and handle payments.')); ?></p>
        </div>
    </div>

    <!-- Stats Row -->
    <div class="row mb-4 g-3">
        <div class="col-6 col-lg-3">
            <div class="card stat-card h-100">
                <div class="card-body text-center">
                    <h6 class="text-muted small text-uppercase mb-2"><?php echo e(__('Total Programmers')); ?></h6>
                    <h3 class="fw-bold mb-0"><?php echo e($programmers->total()); ?></h3>
                </div>
            </div>
        </div>
    </div>

    <div class="card bg-dark border-secondary">
        <div class="card-body p-0">
            <div class="table-responsive table-responsive-stack">
                <table class="table table-hover table-dark mb-0 align-middle">
                    <thead class="bg-black">
                        <tr>
                            <th><?php echo e(__('Name')); ?></th>
                            <th><?php echo e(__('Contact')); ?></th>
                            <th><?php echo e(__('Projects')); ?></th>
                            <th><?php echo e(__('Total Earned')); ?></th>
                            <th><?php echo e(__('Total Paid')); ?></th>
                            <th><?php echo e(__('Outstanding')); ?></th>
                            <th class="text-end"><?php echo e(__('Actions')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $programmers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $programmer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td data-label="<?php echo e(__('Name')); ?>">
                                    <div class="fw-bold"><?php echo e($programmer->name); ?></div>
                                    <small class="text-muted">ID: #<?php echo e($programmer->id); ?></small>
                                </td>
                                <td data-label="<?php echo e(__('Contact')); ?>">
                                    <div><i class="fas fa-envelope me-1 small text-muted"></i><?php echo e($programmer->email); ?></div>
                                    <?php if($programmer->phone): ?>
                                        <div class="small"><i
                                                class="fas fa-phone me-1 small text-muted"></i><?php echo e($programmer->phone); ?></div>
                                    <?php endif; ?>
                                </td>
                                <td data-label="<?php echo e(__('Projects')); ?>">
                                    <span class="badge bg-info"><?php echo e($programmer->projects_count); ?> <?php echo e(__('Projects')); ?></span>
                                </td>
                                <td data-label="<?php echo e(__('Total Earned')); ?>" class="fw-bold">
                                    <?php echo e(number_format($programmer->total_earned, 2)); ?>

                                </td>
                                <td data-label="<?php echo e(__('Total Paid')); ?>" class="text-success">
                                    <?php echo e(number_format($programmer->total_paid, 2)); ?>

                                </td>
                                <td data-label="<?php echo e(__('Outstanding')); ?>"
                                    class="fw-bold <?php echo e($programmer->balance > 0 ? 'text-danger' : 'text-success'); ?>">
                                    <?php echo e(number_format($programmer->balance, 2)); ?>

                                </td>
                                <td data-label="<?php echo e(__('Actions')); ?>" class="text-end">
                                    <a href="<?php echo e(route('accounting.programmers.show', $programmer)); ?>"
                                        class="btn btn-sm btn-outline-info" title="<?php echo e(__('View Account')); ?>">
                                        <i class="fas fa-user-cog"></i>
                                    </a>
                                    <a href="<?php echo e(route('accounting.programmers.edit', $programmer)); ?>"
                                        class="btn btn-sm btn-outline-light" title="<?php echo e(__('Edit')); ?>">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="7" class="text-center py-5 text-muted"><?php echo e(__('No programmers found.')); ?></td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <div class="p-3">
                <?php echo e($programmers->links()); ?>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\code\resources\views/accounting/programmers/index.blade.php ENDPATH**/ ?>